#!/bin/bash
# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: misc/archive/catedit.sh
# Copyright (C) 2004 - 2005 The T2 SDE Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---
#
# WARNING: Create backup copies of your files before you use this tool
# for editing the categories of your packages !!!
#
# Usage: sh misc/archive/catedit.sh package/base/*/*.desc
#    or: sh misc/archive/catedit.sh -a
#

set -e

item='' 
tmp=$( mktemp )

if [ $(dialog --version 2>&1| grep -c "0.9") -eq 0 ]; then
    echo "dialog's version at least 0.9 needed"
    exit 1
fi

if [ "$1" = "-a" -o "$1" = "--all" ]
then files="$(find package/ -name *.desc | sort -t '/' -k 4)"
else files="$@"
fi

until
	pkglst=$(grep '^\[C\]' $files | sed -e 's,^[^:]*/,,;' \
	         -e 's,\.[^ ]* , ",;' -e 's,$,",;' | sed -e 's, "$,",' \
	         | tr '\n' ' ' )

	eval dialog --backtitle \"ROCK Linux package category editor\" \
	       ${item:+--default-item} $item --cancel-label \
	       Quit --menu \"Choose the package you want to edit\" \
	       42 120 35 $pkglst 2> $tmp

	item="$( cat $tmp )"
	cat $tmp
	[ -z "$item" ]
do
	for file in $files; do
		[[ $file = */$item.desc ]] && break
	done
	
	(for category in $(awk '/^[^# ]/ {print $1}' < Documentation/Developers/PKG-CATEGORIES); do
		echo -n $category $category
		if [ -n "$(grep "^\[C\].*$category" $file )" ]
		then echo -e " on "
		else echo -e " off "
		fi
	done ) > $tmp

	dialog --cancel-label Back --backtitle " categories for $item " \
	       --checklist "$(grep '^\[I\]' $file | sed 's/\[I\] //' )" \
	       42 80 35 $(cat $tmp) 2> $tmp
	value=$( cat $tmp | sed -e 's/"//g' -e 's/ $//' )

	if [ "$value" ] ; then 
		cat $file | sed "s,^\[C\] .*,\[C\] $value,g" > $tmp
		cat $tmp > $file
		#grep -v '^\[C\]' "$file" >  $tmp
		#echo -e '\n'"[C] $value" >> $tmp	
		#./scripts/Create-DescPatch $item | patch -p1
	fi
done

rm -f $tmp
