# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by scripts/Create-CopyPatch.
# 
# T2 SDE: package/.../stone/stone_mod_hardware.sh
# Copyright (C) 2004 - 2020 The T2 SDE Project
# Copyright (C) 1998 - 2003 ROCK Linux Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---
#
# [MAIN] 20 hardware Kernel Drivers and Hardware Configuration

store_clock() {
	if [ -f /etc/conf/clock ] ; then
		sed -e "s/clock_tz=.*/clock_tz=$clock_tz/" \
		    -e "s/clock_rtc=.*/clock_rtc=$clock_rtc/" \
		  < /etc/conf/clock > /etc/conf/clock.tmp
		grep -q clock_tz= /etc/conf/clock.tmp || \
		  echo clock_tz=$clock_tz >> /etc/conf/clock.tmp
		grep -q clock_rtc= /etc/conf/clock.tmp || \
		  echo clock_rtc=$clock_rtc >> /etc/conf/clock.tmp
		mv /etc/conf/clock.tmp /etc/conf/clock
	else
		echo -e "clock_tz=$clock_tz\nclock_rtc=$clock_rtc\n" \
		  > /etc/conf/clock
	fi
	if [ -w /proc/sys/dev/rtc/max-user-freq -a "$clock_rtc" ] ; then
		echo $clock_rtc > /proc/sys/dev/rtc/max-user-freq
	fi
}

set_zone() {
	clock_tz=$1
	hwclock --hctosys --$clock_tz
	store_clock
}

set_rtc() {
	gui_input "Set new enhanced real time clock precision" \
                  "$clock_rtc" "clock_rtc"
	store_clock
}

main() {
    while
	clock_tz=utc
	clock_rtc="`cat /proc/sys/dev/rtc/max-user-freq 2> /dev/null`"
	if [ -f /etc/conf/clock ]; then
	    . /etc/conf/clock
	fi

	cmd="gui_menu hw 'Kernel Drivers and Hardware Configuration'"
	    
	if [ "$clock_tz" = localtime ] ; then
	    cmd="$cmd '[*] Use localtime instead of utc' 'set_zone utc'"
	else
	    cmd="$cmd '[ ] Use localtime instead of utc' 'set_zone localtime'"
	    clock_tz=utc
	fi
	cmd="$cmd 'Set enhanced real time clock precision ($clock_rtc)' set_rtc"
 
	eval "$cmd"
    do : ; done

    return
}
