#!/bin/sh

FOOTER='<TABLE WIDTH="100%"><TR><TD><B>ROCK Linux: www.rocklinux.org</B></TD><TD ALIGN=RIGHT>Copyright &copy; 1998-2001 <I>Clifford Wolf</I></TD></TR></TABLE>'

if [ -z "$1" ] ; then
	for x in *.pre ; do
		echo "Processing $x ..."
		./make.sh ${x/.pre/}
	done

	echo "Creating !INDEX.html ..."
	{ echo "<ROCK ROCK Linux Presentation - Index>"
	echo "<ROCK-TITLE-2 http://www.rocklinux.org/projects/doc/doc.html Presentation-Index>"
	echo "<BIGBOX>"
	echo "<TEXTBOX Index>"
	echo "<TABLE>"
	for x in *.pre ; do
		x=${x/.pre/}
		echo "<TR><TH ALIGN=LEFT>`grep . $x.pre | head -1`</TH>"
		echo "  <TD><A HREF=\"$x.1.html\">Slideshow</A></TD>"
		echo "  <TD><A HREF=\"$x.html\">Single Page</A></TD>"
		echo "  <TD><A HREF=\"$x.txt\">ASCII File</A></TD>"
		echo "</TR>"
	done
	echo "</TABLE>"
	echo "</TEXTBOX>"
	echo "</BIGBOX>"
	echo "$FOOTER"
	echo "</ROCK>"
	} | sed -f rock.sed > \!INDEX.html

	exit 0
fi

if [ ! -f "$1.pre" ] ; then
	echo "No such file: '$1.pre'." ; exit 1
fi

rm -f $1.*.html $1.html $1.txt

cat $1.pre | {

	while read x ; do
		if [ "$x" ] ; then
			echo "<ROCK ROCK Linux Presentation - $x>"
			echo "<H1>$x</H1>" ; echo "<BIGBOX>"
			echo "<H1>$x</H1><PRE>" > /tmp/$$.html
			echo "$x" > /tmp/$$.title
			break
		fi
	done

	tee -a /tmp/$$.html | \
	awk '	BEGIN { first=1; }
		/^\[.*\]$/ {
			if (first == 1)
				sub("\\[","<TEXTBOX");
			else
				sub("\\[","</BLOCKQUOTE></B></BIG><P>\\&nbsp;\n</TEXTBOX>\n<P>\n<TEXTBOX");
			sub(" *\\]",">\n\\&nbsp;<P><BIG><B><BLOCKQUOTE>"); first=0; }
		{ print; }'

	echo '</BLOCKQUOTE></B></BIG><P>&nbsp;'
	echo '</TEXTBOX>'
	echo '</BIGBOX>'
	echo "$FOOTER"
	echo '</ROCK>'

} | tee /tmp/$$.in | sed -f rock.sed > $1.html

t="`cat /tmp/$$.title`" ; nr=0

while read x ; do
    if echo "$x" | grep -q '^<TEXTBOX ' ; then
    	echo '</BIGBOX>' >> $1.$nr.in
	echo "$FOOTER" >> $1.$nr.in
    	echo '</ROCK>' >> $1.$nr.in
    	nr=$(( $nr + 1 ))
    	{
    		echo "<ROCK ROCK Linux Presentation - $t>"
		last=$1.$(($nr-1)).html ; next=$1.$(($nr+1)).html
		cat << EOT
<TABLE WIDTH="100%">
<TR><TD>
  <P> &nbsp; <H1> &nbsp; &nbsp; $t </H1>
</TD><TD ALIGN=RIGHT>
  <A HREF="$last"><IMG SRC="back.gif" BORDER=0 WIDTH="40" HEIGHT="40"
                       ALT="Last"></A> &nbsp;&nbsp;&nbsp;
  <A HREF="!INDEX.html"><IMG SRC="up.gif" BORDER=0 WIDTH="40" HEIGHT="40"
                       ALT="Up"></A>   &nbsp;&nbsp;&nbsp;
  <A HREF="$next"><IMG SRC="next.gif" BORDER=0 WIDTH="40" HEIGHT="40"
                       ALT="Next"></A>
</TD></TR></TABLE>
<BIGBOX>
EOT
    	} > $1.$nr.in
    fi
    echo "$x" >> $1.$nr.in
done < /tmp/$$.in

for x in $1.*.in ; do
	sed -f rock.sed < $x > ${x/.in/.html}
done

cp $1.1.html $1.0.html
cp $1.$nr.html $1.$(($nr+1)).html

egrep -v '^</?UL>$' < /tmp/$$.html | sed 's,<LI>,*,;' > /tmp/$$.dat
mv /tmp/$$.dat /tmp/$$.html ; lynx -dump /tmp/$$.html > $1.txt
rm /tmp/$$.html /tmp/$$.title /tmp/$$.in $1.*.in
