#!/bin/sed -f

# Converting a ROCK Linux Homepage .in file to a .html file.
# (C) 1999 Clifford Wolf, licensed under the GPL
#
# Usage:  sed -f rock.sed < file.in > file.html

# Comments
/^#/ {
	s,<,(,g;
	s,>,),g;
	s,^#\(.*\),<!--\1 -->,;
}

# HTML Head and Tail
#
s,<ROCK \([^>]*\)>,<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">\
<HTML><HEAD><TITLE>\1</TITLE></HEAD>\
<BODY BGCOLOR="#FFFFFF" TEXT="#000000" LINK="#0000FF" VLINK="#2222BB" ALINK="#0077FF">\
<!--\
        This HTML Page is generated using the rock.sed script which\
        can be found at "http://www.rocklinux.org/rock.sed".\
\
	Have a look at "http://www.rocklinux.org/getting.in" for an\
        example input file.\
\
        If you would like to create HTML Pages with the look of the\
        ROCK Linux Homepage\, please contact me first.\
\
            - Clifford Wolf (clifford@clifford.at)\
-->,g
s,</ROCK>,</BODY></HTML>,g

# BIG box
#
s,<BIGBOX>,<BIGBOX #CC3366>,g
s,<BIGBOX-ORG>,<BIGBOX #CC3366>,g
s,<BIGBOX-COM>,<BIGBOX #3366CC>,g
s,<BIGBOX-NET>,<BIGBOX #33CC66>,g
s,<BIGBOX \([^>]*\)>,<!-- BIGBOX ON (\1) --><TABLE CELLSPACING="0" CELLPADDING="2" BORDER="0" WIDTH="100%" BGCOLOR="#000000"><TR><TD><TABLE CELLSPACING="0" CELLPADDING="10" BORDER="0" WIDTH="100%" BGCOLOR="\1"><TR><TD VALIGN=TOP>,g
s,</BIGBOX>,<!-- BIGBOX OFF --></TD></TR></TABLE></TD></TR></TABLE>,g


# Text box
#
s,<TEXTBOX \([^>]*\)>,<!-- TEXTBOX ON (\1) --><TABLE CELLSPACING="0" CELLPADDING="3" BORDER="0" WIDTH="100%"  BGCOLOR="#000000"><TR><TD><BIG><B><FONT COLOR="#FFFFFF"> \&nbsp; \1</FONT></B></BIG></TD></TR><TR><TD><TABLE CELLSPACING="0" CELLPADDING="3" BORDER="0" WIDTH="100%" BGCOLOR="#FFFFFF"><TR><TD VALIGN=TOP>,g
s,<TEXTBOX>,<!-- TEXTBOX ON --><TABLE CELLSPACING="0" CELLPADDING="3" BORDER="0" WIDTH="100%"  BGCOLOR="#000000"><TR><TD><TABLE CELLSPACING="0" CELLPADDING="3" BORDER="0" WIDTH="100%" BGCOLOR="#FFFFFF"><TR><TD VALIGN=TOP>,g
s,<TEXTBOX-GREY>,<!-- TEXTBOX ON --><TABLE CELLSPACING="0" CELLPADDING="3" BORDER="0" WIDTH="100%"  BGCOLOR="#000000"><TR><TD><TABLE CELLSPACING="0" CELLPADDING="3" BORDER="0" WIDTH="100%" BGCOLOR="#CCCCCC"><TR><TD VALIGN=TOP>,g
s,</TEXTBOX>,<!-- TEXTBOX OFF --></TD></TR></TABLE></TD></TR></TABLE>,g

# Small Helpers
#
s,<MENU-ITEM-OLD \+\([^ ]*\) \+\([^>]*\)>,\&nbsp;\&nbsp;\&nbsp;\&nbsp;<B>\&gt;</B>\&nbsp;\&nbsp;<A HREF="\1"><B>\2</B></A>\&nbsp;<BR>,g
#
s,<ROCK-TITLE \([^>]*\)>,<!-- ROCK-TITLE --><TABLE WIDTH="100%"><TR><TD><P> \&nbsp; <H1> \&nbsp; \&nbsp; \1 </H1></TD><TD ALIGN=RIGHT><A HREF="http://www.rocklinux.org/index.html"><IMG SRC="http://www.rocklinux.org/pics/home.gif" BORDER=0 WIDTH="40" HEIGHT="40" ALT="Back to ROCK Linux Home"></A></TD></TR></TABLE>,g
#
s,<ROCK-TITLE-2 \([^ ]*\) \([^>]*\)>,<!-- ROCK-TITLE-2 --><TABLE WIDTH="100%"><TR><TD><P> \&nbsp; <H1> \&nbsp; \&nbsp; \2 </H1></TD><TD ALIGN=RIGHT><A HREF="javascript:history.back()"><IMG SRC="http://www.rocklinux.org/pics/back.gif" BORDER=0 WIDTH="40" HEIGHT="40" ALT="Back"></A>\&nbsp;\&nbsp;\&nbsp;<A HREF="\1"><IMG SRC="http://www.rocklinux.org/pics/up.gif" BORDER=0 WIDTH="40" HEIGHT="40" ALT="Up"></A>\&nbsp;\&nbsp;\&nbsp;<A HREF="http://www.rocklinux.org/index.html"><IMG SRC="http://www.rocklinux.org/pics/home.gif" BORDER=0 WIDTH="40" HEIGHT="40" ALT="Home"></A></TD></TR></TABLE>,g
#
s,<MENU-ITEM \+\([^ ]*\) \+\([^>]*\)>,<TR><TD><B>\&gt;</B></TD><TD><A HREF="\1"><B>\2</B></A></TD></TR>,g


# Standard Footers
#
s,<FOOTER>,<!-- ROCK Footer --><TABLE WIDTH="100%"><TR><TD ALIGN=LEFT VALIGN=BOTTOM><B>ROCK Linux - This will rock you!<BR>Check out our Portal Site: <A HREF="http://www.rocklinux.net/">www.rocklinux.net</A><BR>Copyright \&copy; 1998-2001 <A HREF="http://www.clifford.at"><I>Clifford Wolf</I></A></TD><TD ALIGN=RIGHT><A HREF="http://www.rock-projects.com/"><IMG WIDTH="160" HEIGHT="50" SRC="http://www.rocklinux.org/pics/pow-rock.jpg" BORDER=0 ALT="Powered by ROCK"></A></TD></TR></TABLE>,g;
s,<FOOTER \+\([^ ]*\) \+\([^ ]*\) \+\([^ ]*\)>,<!-- ROCK Footer --><TABLE WIDTH="100%"><TR><TD ALIGN=LEFT VALIGN=BOTTOM><B>ROCK Linux - This will rock you!<BR>Check out our Portal Site: <A HREF="http://www.rocklinux.net/">www.rocklinux.net</A><BR>Copyright \&copy; \1 <A HREF="\3"><I>\2</I></A></TD><TD ALIGN=RIGHT><A HREF="http://www.rock-projects.com/"><IMG WIDTH="160" HEIGHT="50" SRC="http://www.rocklinux.org/pics/pow-rock.jpg" BORDER=0 ALT="Powered by ROCK"></A></TD></TR></TABLE>,g;

# About Text
#
s|<ROCK-ABOUT>|<!-- ROCK ABOUT --> \
ROCK Linux is a modern Linux Distribution with a powerfull auto-build \
process, mostly designed for skilled Linux/Unix Administrators and available \
for multiple platforms. ROCK Linux is a small distribution, but \
it's not a "mini distribution". It comes with over 200 packages including \
X11 and the GNOME Desktop - but excluding menu driven configuration tools \
(most professional users prefer configuration files), but a reasonably well \
configured installation of Rock Linux should be useful for any computer \
user (even beginners). ROCK Linux is free under the tems of the GPL.|g;
