#!/bin/sh

echo -n "Creating arch configs for Intel PCs:"
for x in i386 i486 i586 pentium i686 pentiumpro k6 k7 athlon ; do
	echo -n " $x" ; rm -rf $x
	case $x in
		pentium)     ln -s i586 pentium    ; continue ;;
		pentiumpro)  ln -s i686 pentiumpro ; continue ;;
		athlon)      ln -s k7   athlon     ; continue ;;
	esac
	mkdir $x ; echo > $x/AUTOCREATED
	ln -s ../intel/README ../intel/float.h ../intel/include \
	      ../intel/libgcc1.a $x/
	case $x in
		i386) lx_machine=CONFIG_M386 ; cc_machine=i386
		      gcc_options='-march=i386 -mcpu=i386' ;;
		i486) lx_machine=CONFIG_M486 ; cc_machine=i486
		      gcc_options='-march=i486 -mcpu=i486' ;;
		i586) lx_machine=CONFIG_M586 ; cc_machine=i586
		      gcc_options='-march=i586 -mcpu=i586' ;;
		i686) lx_machine=CONFIG_M686 ; cc_machine=i686
		      gcc_options='-march=i686 -mcpu=i686' ;;
		k6)   lx_machine=CONFIG_MK6 ; cc_machine=i586
		      gcc_options='-march=i586 -mcpu=k6' ;;
		k7)   lx_machine=CONFIG_MK7 ; cc_machine=i686
		      gcc_options='-march=i686 -mcpu=k7' ;;
	esac
	sed "s/i386/$cc_machine/" < intel/archtest.out > $x/archtest.out
	echo -e "#\n# !!! Don't edit this file - edit" \
	        "../intel/kernel.conf !!!\n#\n" > $x/kernel.conf
	sed -e "s/^CONFIG_M386=y/# CONFIG_M386 is not set/" \
	    -e "s/^#.*$lx_machine .*/$lx_machine=y/" \
	    < intel/kernel.conf >> $x/kernel.conf
	echo "$gcc_options" > $x/gcc-options
done

echo
