#!/bin/sh

if [ -e scripts ] ; then
	echo "WARNING: copy-inc.sh is not meant to be executed in the"
	echo "ROCK Linux top-level directory!"
	exit -1
fi

rm -rf */ ; find . -type f ! -name 'copy-inc.sh' | xargs rm -f

files="stdio.h string.h stdlib.h unistd.h errno.h limits.h"

for x in $files ; do
	[ -f $x ] || cp -v /usr/include/$x .
	egrep '^# *(include|define.*_H)' < $x > x.h
	cpp -D_GNU_SOURCE -M x.h | tr ' ' '\n' |
	grep '/usr/include/' | perl -pe \
's,^(.*/usr/include/)(.*)(/.*),[ -f $2$3 ] || { mkdir -p $2 ; '\
'cp -v $1$2$3 $2$3 ; },; s,^(/usr/include/)(.*),[ -f $2 ] || '\
'cp -v $1$2 $2,;' | sh
done

rm -f x.h

echo 'Created by arch-conf/share/copy-inc.sh.' > README

