#!/bin/sh

if [ ! -f "$1" ] ; then
	echo
	echo "Usage: $0 <file(s)-for-compression-test>"
	echo
	echo "E.g.: $0 /boot/System.map /boot/vmlinuz"
	echo
	exit
fi

export TIMEFORMAT="%3U+%3S+0.001"

echo

echo -n 'Programm | Compress Time         '
echo    '| Uncompress Time       | Compression Rate'
for x ; do

    echo -n -
    
    bz2time1=`{ time bzip2 < "$x" > /tmp/$$.bz2 ; } 2>&1 | bc` ; echo -n -
    bz2time2=`{ time bunzip2 < /tmp/$$.bz2 > /tmp/$$.dat ; } 2>&1 | bc`
    bz2size=`ls -l /tmp/$$.bz2 | tr -s ' ' | cut -f5 -d' '` ; echo -n -
    
    gztime1=`{ time gzip < "$x" > /tmp/$$.gz ; } 2>&1 | bc` ; echo -n -
    gztime2=`{ time gunzip < /tmp/$$.gz > /tmp/$$.dat ; } 2>&1 | bc`
    gzsize=`ls -l /tmp/$$.gz | tr -s ' ' | cut -f5 -d' '` ; echo -n -
    
    comptime1=`{ time compress < "$x" > /tmp/$$.comp ; } 2>&1 | bc` ; echo -n -
    comptime2=`{ time uncompress < /tmp/$$.comp > /tmp/$$.dat ; } 2>&1 | bc`
    compsize=`ls -l /tmp/$$.comp | tr -s ' ' | cut -f5 -d' '` ; echo -n -
    
    rm -f /tmp/$$.bz2 /tmp/$$.gz /tmp/$$.comp /tmp/$$.dat ; echo -n -
    
    maxtime1=$bz2time1
    expr $maxtime1 \< $gztime1   >/dev/null && maxtime1=$gztime1
    expr $maxtime1 \< $comptime1 >/dev/null && maxtime1=$comptime1
    
    bz2time1=`echo  "(($bz2time1 *19)/$maxtime1)/1" | bc`
    gztime1=`echo   "(($gztime1  *19)/$maxtime1)/1" | bc`
    comptime1=`echo "(($comptime1*19)/$maxtime1)/1" | bc`
    
    maxtime2=$bz2time2
    expr $maxtime2 \< $gztime2   >/dev/null && maxtime2=$gztime2
    expr $maxtime2 \< $comptime2 >/dev/null && maxtime2=$comptime2
    
    bz2time2=`echo  "(($bz2time2 *19)/$maxtime2)/1" | bc`
    gztime2=`echo   "(($gztime2  *19)/$maxtime2)/1" | bc`
    comptime2=`echo "(($comptime2*19)/$maxtime2)/1" | bc`
    
    maxsize=$bz2size
    expr $maxsize \< $gzsize   >/dev/null && maxsize=$gzsize
    expr $maxsize \< $compsize >/dev/null && maxsize=$compsize
    
    bz2size=`echo  "(($bz2size *19)/$maxsize)/1" | bc`
    gzsize=`echo   "(($gzsize  *19)/$maxsize)/1" | bc`
    compsize=`echo "(($compsize*19)/$maxsize)/1" | bc`
    
    echo_stars() {
	nr=0
	while [ $nr -lt $1 ] ; do echo -n 'X' ; nr=$(($nr+1)) ; done
	while [ $nr -lt $2 ] ; do echo -n ':' ; nr=$(($nr+1)) ; done
    }
    
    echo -n '-+-----------------------+----------'
    echo    '-------------+----------------------'
    
    echo -n "Bzip2    | X"
       echo_stars $((19 - $bz2time1)) 19 ; echo -n ': | X'
       echo_stars $((19 - $bz2time2)) 19 ; echo -n ': | X'
       echo_stars $((19 -  $bz2size)) 19 ; echo :
    
    echo -n "Gzip     | X"
       echo_stars $((19 - $gztime1)) 19 ; echo -n ': | X'
       echo_stars $((19 - $gztime2)) 19 ; echo -n ': | X'
       echo_stars $((19 -  $gzsize)) 19 ; echo :
    
    echo -n "Compress | X"
       echo_stars $((19 - $comptime1)) 19 ; echo -n ': | X'
       echo_stars $((19 - $comptime2)) 19 ; echo -n ': | X'
       echo_stars $((19 -  $compsize)) 19 ; echo :
    
done

echo
echo "   More X'es = better."
echo
