
/*  gcc -Wall -O2 scrsav.c -o scrsav  */
/*  while : ; do ./scrsav /dev/vcc/a2 /dev/vcc/a3 ; sleep 5 ; done  */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <stdlib.h>
#include <endian.h>

#ifdef iMAC_CON
#  define LINES 48
#  define CHARS 128
#else
#  define LINES 25
#  define CHARS 80
#endif

#define BUFSIZE (LINES*CHARS*2)
#define LINESIZE (CHARS*2)

int main(int argc, char ** argv) {
	char buffer[BUFSIZE];
	char miscdata[4];
	int fd,c,i,j;

	if (argc != 3) {
		fprintf(stderr, "Usage: %s <src-vcs> <trg-vcs>\n", argv[0]);
		fprintf(stderr, "E.g.: %s /dev/vcc/a2 /dev/vcc/a3\n", argv[0]);
		return 1;
	}

	fd=open(argv[1], O_RDONLY);
	if (fd < 0) { perror(argv[1]); return 1; }
	read(fd, miscdata, 4);
	read(fd, buffer, BUFSIZE);
	close(fd);

	srandom( time(NULL) + getpid() );

	for (c=0; c<BUFSIZE-1; c+=2) {
#if __BYTE_ORDER == __LITTLE_ENDIAN
		i=c+1; j=c;
#else
		j=c+1; i=c;
#endif
		buffer[i] ^= buffer[j] ^ c ^ random() ;
		if ( c/LINESIZE+1 != time(NULL) % LINES )
			buffer[i] &= 0x0f;
	}
	
	fd=open(argv[2], O_WRONLY);
	if (fd < 0) { perror(argv[2]); return 1; }
	write(fd, miscdata, 4);
	write(fd, buffer, BUFSIZE);
	close(fd);
	
	return 0;
}
