/* Simple SMP Benchmark Programm by Clifford */

/* gcc -lpthread -lm smpbench.c -o smpbench -O2 -Wall */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <math.h>

void* thread1(void *);
void* thread2(void *);
void* thread3(void *);
void* thread4(void *);

void* thread1(void *x) {
	int c1,c2,c3=0;
	printf("[1] Start -> %ld %d\n",pthread_self(),getpid());
	for (c1=2; c1<50000; c1++) {
		for (c2=2; c2<c1/2; c2++)
			if (c1%c2 == 0) goto noprim;
		c3++;
noprim:
	}
	printf("[1] Found %d Prim numbers from 2 to 50000.\n",c3);
	return NULL;
}

void* thread2(void *x) {
	unsigned char data[10000],datax;
	int c1,c2=0,num=500,ok=0;
	printf("[2] Start -> %ld %d\n",pthread_self(),getpid());
	for (c1=0; c1<10000; c1++) num+=(data[c1]=(c1^num)+c1*num);
	while (!ok) {
		ok=1;
		for (c1=1; c1<10000; c1++)
			if (data[c1] < data[c1-1]) {
				datax=data[c1];
				data[c1]=data[c1-1];
				data[c1-1]=datax;
				c2++; ok=0;
			}
	}
	printf("[2] Needed %d x-chages to bubble sort the 10000 "
	       "elements array.\n",c2);
	return NULL;
}

void* thread3(void *x) {
	double c1,dat=0;
	printf("[3] Start -> %ld %d\n",pthread_self(),getpid());
	for (c1=0; c1<10000000; c1++) dat=+sqrt(c1);
	for (c1=0; c1<10000000; c1++) dat=-sqrt(c1);
	for (c1=0; c1<10000000; c1++) dat=-sqrt(c1);
	for (c1=0; c1<10000000; c1++) dat=+sqrt(c1);
	printf("[3] Here is a Number: %f\n",(float)dat);
	return NULL;
}

void* thread4(void *x) {
	int c=0;
	printf("\n");
	while (1) { printf("\r<%02d> ",c++); fflush(stdout); sleep(1); }
	return NULL; 
}

int main() {
	pthread_t t1,t2,t3,t4;
	int c;

	pthread_create(&t4,NULL,thread4,NULL);
	pthread_detach(t4);

	sleep(2); printf("Main PID: %d\n",getpid());
	
	for (c=0; c<3; c++){
		sleep(2); pthread_create(&t1,NULL,thread1,NULL);
		sleep(2); pthread_create(&t2,NULL,thread2,NULL);
		sleep(2); pthread_create(&t3,NULL,thread3,NULL);
		pthread_join(t1,NULL);
		pthread_join(t2,NULL);
		pthread_join(t3,NULL);
	}
	
	sleep(2); printf("READY.\n\n");
	
	return 0;
}
