#include <stdio.h>
#include <string.h>
#include <stdlib.h>

extern int dump_modules_main(int, char**);
extern int dump_ifconfig_main(int, char**);
extern int dump_route_main(int, char**);
extern int dump_ipchains_main(int, char**);
extern int dump_iptables_main(int, char**);
extern int dump_ipnatctl_main(int, char**);
extern int dump_proc_main(int, char**);

int main(int argc, char ** argv) {
	/* Disable the gettext library */
	setenv("LC_ALL","POSIX",1);
	unsetenv("LANG"); /* paranoia */

	/* Start modules part? */
	if (argc >= 2 && !strcmp(argv[1],"modules"))
		return dump_modules_main(argc,argv);
	
	/* Start ifconfig part? */
	if (argc >= 2 && !strcmp(argv[1],"ifconfig"))
		return dump_ifconfig_main(argc,argv);
	
	/* Start route part? */
	if (argc >= 2 && !strcmp(argv[1],"route"))
		return dump_route_main(argc,argv);
	
	/* Start ipchains part? */
	if (argc >= 2 && !strcmp(argv[1],"ipchains"))
		return dump_ipchains_main(argc,argv);
	
	/* Start iptables part? */
	if (argc >= 2 && !strcmp(argv[1],"iptables"))
		return dump_iptables_main(argc,argv);
	
	/* Start ipnatctl part? */
	if (argc >= 2 && !strcmp(argv[1],"ipnatctl"))
		return dump_ipnatctl_main(argc,argv);
	
	/* Start proc-fs part? */
	if (argc >= 2 && !strcmp(argv[1],"proc"))
		return dump_proc_main(argc,argv);
	
	/* Usage info. */
	fprintf(stderr,"Usage: %s < modules | ifconfig | route | ipchains | "
	               "proc > < .... >\n",argv[0]);
	fprintf(stderr,"       %s < iptables | "
	               "ipnatctl > < .... >\n",argv[0]);
	return 1;
}
