.\"
.\" dump-config - written by Clifford Wolf (www.clifford.at)
.\" 
.\" This program is part of the ROCK Linux Distribution.
.\"
.\" ==> http:/linux.rock-projects.com/
.\"
.TH DUMP-CONFIG 8 "September 5, 1999" "ROCK Linux" ""
.SH NAME
dump-config \- Linux Configuration Dumper
.SH SYNOPSIS
.BR "dump-config modules   " "up | down  [ old-dump ]"
.br
.BR "dump-config ifconfig  " "up | down"
.br
.BR "dump-config route     " "up | down"
.br
.BR "dump-config ipchains  " "up | down"
.br
.BR "dump-config iptables  " "up | down"
.br
.BR "dump-config ipnatctl  " "up | down"
.br
.BR "dump-config proc      " "path  [ old-dump ]"
.SH DESCRIPTION
.B Dump-config
is used to gereate system start/stop scripts based on the running
configuration.

Currently the following modes are supported:
.TP
.BR "dump-config modules " "up | down  [ old-dump ]"
  This dumps out the calls to the
.B insmod
program which are needed to load all the kernel modules currently loaded.
The parameter 'up' is used to generate a start-, the parameter 'down' to
generate a stop-script.
  There is no way to get a list of the symbol definitions used when loading
the modules (i.e. I've not found one). So, If you want to use symbol
definitions, you need to add them to the old dump and use it's filename
as 2nd parameter. The program extracts the sybol definitions from the old
dump and uses them in the new one.
.TP
.BR "dump-config ifconfig " "up | down"
  This dumps out the calls to the
.B ifconfig
program which are needed to set the network interfaces to the same status as
they are currently. The parameter 'up' is used to generate a start-, the
parameter 'down' to generate a stop-script.
.TP
.BR "dump-config route " "up | down"
  This dumps out the calls to the
.B route
program which are needed to set the routing table to the same status as
it is currently. The parameter 'up' is used to generate a start-, the
parameter 'down' to generate a stop-script.
.TP
.BR "dump-config ipchains " "up | down"
  This dumps out the calls to the
.B ipchains
program which are needed to set the firewalling configuration to the same
status as it is currently. The parameter 'up' is used to generate a start-,
the parameter 'down' to generate a stop-script.

.B NOTE:
The ipchains system has been replaced by netfilter (iptables and ipnatctl)
in Kernel 2.3.15.
.TP
.BR "dump-config iptables " "up | down"
  This dumps out the calls to the
.B iptables
program which are needed to set the firewalling configuration to the same
status as it is currently. The parameter 'up' is used to generate a start-,
the parameter 'down' to generate a stop-script.
.TP
.BR "dump-config ipnatctl " "up | down"
  This dumps out the calls to the
.B ipnatctl
program which are needed to set the NAT/Masqurading/etc. configuration to the
same status as it is currently. The parameter 'up' is used to generate a
start-, the parameter 'down' to generate a stop-script.
.TP
.BR "dump-config proc " "path  [ old-dump ]"
  This dumps out the calls to the
.B echo
program which are needed to set the configurations in the proc sys-ctl
interface as they are currently. The path parameter should allways
be '/proc/sys'.
  The optional paramterer old-dump is the filename of an older output of
.B dump-config proc.
If it is used only the settings which have been changed are dumped.
.SH BUGS
  When ifconfig sets up an interface the kernel automatically creates a route
for the network assigned to this interface (have a look at fib_add_ifaddr()
in /usr/src/linux/net/ipv4/fib_frontend.c for details). This route is dumped
out by
.B dump-config route
and will be created a 2nd time when the dump script is executed.
  A workarround for this is to explicitly clean up the routing table before
executing the dumped script:
.br
.B "  sh if.dump ; dump-config route down | sh ; sh route.dump"

  Inet is the only supported address family. Probably I'm going to add
Inet6 support later. There are no plans to support other address families
than Inet (IPv4) and Inet6 (IPv6).

  In the modes ifconfig, route, ipchains and iptables dump-config doesn't use the kernel
interfaces directly. Instead the diagnostic output of the programs ifconfig,
route, ipchains and iptables is used. If the output format of this programs changes it
can break dump-config.

  I do own only ethernet cards. So all the ifconfig options for other network
interfaces are implemented but not tested.
.SH NOTES
Dump-config has been developed and tested on Ifconfig 1.39, Route 1.96,
Ipchains 1.3.9, Netfilter 0.1.12 and Linux 2.2.10 / 2.3.26.

Dump-config is part of the ROCK Linux Distribution
(http://linux.rock-projects.com) and is not available as stand-alone
package.
.SH SEE ALSO
ifconfig(8), route(8), ipchains(8), iptables(8), proc(5)
.SH AUTHOR
Clifford Wolf <god@clifford.at>, http://www.clifford.at/
