#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define ifopt(ifname,fmt,args...) { char tmp[256]; \
   sprintf(tmp,"ifconfig %s " fmt " %s >/dev/null 2>&1",ifname , ##args , \
   upflag?"up":"down"); if ( up && system(tmp) == 0 ) { printf("%s " fmt, \
   cmdstart , ##args ); cmdstart[0]=0; } }

#define ifoptx(ifname,fmt_down,fmt,args...) { char tmp[256]; \
    sprintf(tmp,"ifconfig %s " fmt " %s >/dev/null 2>&1",ifname , ##args , \
    upflag?"up":"down"); if ( system(tmp) == 0 ) { if (up) printf("%s " fmt, \
    cmdstart , ##args ); else printf("%s " fmt_down,cmdstart); cmdstart[0]=0; } }

int isifup(char * ifname) {
	FILE * f;
	int rc=0;
	char txt[256];
	
	sprintf(txt,"ifconfig %s",ifname);
	f=popen(txt,"r"); txt[255]=0;
	while ( fgets(txt,255,f) != NULL )
		if (strstr(txt," UP ")) { rc=1; break; }
	fclose(f);

	return rc;
}

int dump_ifconfig_main(int argc, char ** argv) {
	int up=0,upflag=0;
	char * tag;
	FILE *f;
	
	char line[256],ifname[256],cmdstart[256];
	char val[256],val2[256],val3[256];
	
	if ( argc==3 && !strcmp(argv[2],"up") ) up=1;
	else if ( argc==3 && !strcmp(argv[2],"down") ) up=0;
	else {
		fprintf(stderr,"Usage: %s %s < up | down >\n",argv[0],argv[1]);
		return 1;
	}
	
	f=popen("ifconfig -a","r"); line[255]=0;
	while ( fgets(line,255,f) != NULL ) {
		if (line[0]=='\n') {
			if (upflag) { ifoptx(ifname,"down","up"); }
			else if (up && !cmdstart[0]) { ifopt(ifname,"down"); }
			if (!cmdstart[0]) printf("\n"); continue;
		}
		if (isalnum(line[0])) {
			sscanf(line,"%s",ifname); upflag=isifup(ifname);
			sprintf(cmdstart,"ifconfig %s",ifname);
		}
		
		tag=strstr(line," HWaddr ");
		if (tag && sscanf(tag," HWaddr %s",val) == 1) {
		    tag=strstr(line," Link encap:");
		    if (tag && sscanf(tag," Link encap: %[^\n]",val2) == 1) {
			tag=strstr(val2,"  ");  if (tag) tag[0]=0;
			if (!strcmp(val2,"Ethernet"))     strcpy(val3,"ether");
			if (!strcmp(val2,"AMPR AX.25"))   strcpy(val3,"ax25");
			if (!strcmp(val2,"ARCnet"))       strcpy(val3,"ARCnet");
			if (!strcmp(val2,"AMPR NET/ROM")) strcpy(val3,"netrom");
			if (val3[0]) ifopt(ifname,"hw %s %s",val3,val);
		    }
		}
		
		tag=strstr(line," Media:");
		if (tag && sscanf(tag," Media:%[^ (]",val) == 1)
			ifopt(ifname,"media %s",val);
		
		tag=strstr(line," inet addr:");
		if (tag && sscanf(tag," inet addr:%s",val) == 1)
			ifopt(ifname,"%s",val);
		
		tag=strstr(line," P-t-P:");
		if (tag && sscanf(tag," P-t-P:%s",val) == 1)
			ifopt(ifname,"pointopoint %s",val);
		
		tag=strstr(line," Bcast:");
		if (tag && sscanf(tag," Bcast:%s",val) == 1)
			ifopt(ifname,"broadcast %s",val);
		
		tag=strstr(line," Mask:");
		if (tag && sscanf(tag," Mask:%s",val) == 1)
			ifopt(ifname,"netmask %s",val);
		
		if (strstr(line," LOOPBACK ") != NULL)
			ifopt(ifname,"loopback");
		
		if (strstr(line," NOARP ") != NULL)
			ifopt(ifname,"-arp");
		
		if (strstr(line," PROMISC ") != NULL)
			ifopt(ifname,"promisc");
		
		if (strstr(line," ALLMULTI ") != NULL)
			ifopt(ifname,"allmulti");
		
		if (strstr(line," MULTICAST ") != NULL)
			ifopt(ifname,"multicast");
		
		tag=strstr(line," MTU:");
		if (tag && sscanf(tag," MTU:%s",val) == 1)
			ifopt(ifname,"mtu %s",val);
		
		tag=strstr(line," Metric:");
		if (tag && sscanf(tag," Metric:%s",val) == 1)
			ifopt(ifname,"metric %s",val);
		
		tag=strstr(line," txqueuelen:");
		if (tag && sscanf(tag," txqueuelen:%s",val) == 1)
			ifopt(ifname,"txqueuelen %s",val);
		
		tag=strstr(line," Interrupt:");
		if (tag && sscanf(tag," Interrupt:%s",val) == 1)
			ifopt(ifname,"irq %s",val);
		
		tag=strstr(line," Base address:");
		if (tag && sscanf(tag," Base address:%s",val) == 1)
			ifopt(ifname,"io_addr %s",val);
		
		tag=strstr(line," Memory:");
		if (tag && sscanf(tag," Memory:%s",val) == 1)
			ifopt(ifname,"mem_start %s",val);
	}
	pclose(f);
	return 0;
}
