#include <stdio.h>
#include <string.h>

void add_blank_after_bang(char * str) {
	char buf[256];
	if (str[0] == '!') {
		sprintf(buf,"! %s",str+1);
		strcpy(str,buf);
	}
}

int dump_ipchains_main(int argc, char ** argv) {
	FILE * f;
	
	char buf[256],chain[256],target[256];
	char prot[256],opt[256],source[256];
	char dest[256],port1[256],port2[256];
	char tosa[256],tosx[256],ifname[256];
	char mark[256],outsize[256],buf2[256];
	
	buf[255]=chain[255]=target[255]=0;
	prot[255]=opt[255]=source[255]=0;
	dest[255]=port1[255]=port2[255]=0;
	tosa[255]=tosx[255]=ifname[255]=0;
	mark[255]=outsize[255]=buf2[255]=0;
	
	if ( argc==3 && !strcmp(argv[2],"down") ) {
		printf("ipchains -P input ACCEPT ; ");
		printf("ipchains -P forward ACCEPT\n");
		printf("ipchains -P output ACCEPT ; ");
		printf("ipchains -F ; ipchains -X ; ipchains -Z\n");
		return 0;
	} else if ( argc!=3 || strcmp(argv[2],"up") ) {
		fprintf(stderr,"Usage: %s %s < up | down >\n",argv[0],argv[1]);
		return 1;
	}

	/*
	 *  Create non-builtin Chains and set default policies
	 */
	f=popen("ipchains -L -n","r");
	while ( fgets(buf,255,f) )
	  if ( sscanf(buf,"Chain %s (%*s %[^)]",chain,target) == 2 ) {
		if ( strcmp(chain,"input") && strcmp(chain,"forward") &&
		    strcmp(chain,"output") ) printf("ipchains -N %s\n",chain);
		else
		    printf("ipchains -P %s %s\n",chain,target);
	  }
	fclose(f);
	
	/*
	 *  Create rules
	 */
	f=popen("ipchains -L -n -v","r");
	while ( fgets(buf,255,f) ) {
		if ( sscanf(buf,"Chain %s ",chain) == 1 ) continue;
		if ( sscanf(buf," pkts bytes %s",target) == 1 ) continue;
		sscanf(buf,"%*s %*s %s %s %s %s %s %s",target,prot,opt,
		       tosa,tosx,ifname);
		strncpy(buf2,buf+57,12); buf2[12]=mark[0]=0; sscanf(buf2,"%s",mark);
		strncpy(buf2,buf+68,7); buf2[9]=outsize[0]=0; sscanf(buf2,"%s",outsize);
		sscanf(buf+75,"%s %s %s -> %s",source,dest,port1,port2);
		add_blank_after_bang(prot);    add_blank_after_bang(ifname);
		add_blank_after_bang(source);  add_blank_after_bang(port1);
		add_blank_after_bang(dest);    add_blank_after_bang(port2);
		if ( !strcmp(port1,"n/a") )
			{ strcpy(port1,"*"); strcpy(port2,"*"); }
		printf("ipchains -A %s",chain);
		if ( strcmp(prot,"all") ) printf(" -p %s",prot);
		if ( strcmp(source,"0.0.0.0/0") ) printf(" -s %s",source);
		if ( strcmp(port1,"*") ) {
			if ( strcmp(source,"0.0.0.0/0") ) printf(" %s",port1);
			else printf(" --source-port %s",port1);
		}
		if ( strcmp(dest,"0.0.0.0/0") ) printf(" -d %s",dest);
		if ( strcmp(port2,"*") ) {
			if ( strcmp(dest,"0.0.0.0/0") ) printf(" %s",port2);
			else printf(" --destination-port %s",port2);
		}
		if ( strcmp(ifname,"*") ) printf(" -i %s",ifname);
		if ( strchr(opt,'f') ) {
			if ( strchr(opt,'f')[-1]=='!' ) printf(" !");
			printf(" -f");
		}
		if ( strchr(opt,'l') ) printf(" -l");
		if ( strchr(opt,'o') ) {
			printf(" -o");
			if ( outsize[0] ) printf(" %s",outsize);
		}
		if ( mark[0] ) printf(" -m %s",mark);
		if ( strcmp(tosa,"0xFF") || strcmp(tosx,"0x00") )
			printf(" -t %s %s",tosa,tosx);
		if ( strchr(opt,'y') ) {
			if ( strchr(opt,'y')[-1]=='!' ) printf(" !");
			printf(" -y");
		}
		if ( strcmp(target,"-") ) printf(" -j %s",target);
		printf("\n");
	}
	fclose(f);
	
	return 0;
}
