#include <stdio.h>
#include <string.h>

/* xfgets() from iptables.c */
extern char * xfgets(char *s, int size, FILE *stream);

char * dump_ipnatctl_gtbuf;

char * dump_ipnatctl_gettag() {
	char * tag=dump_ipnatctl_gtbuf;
	while (*dump_ipnatctl_gtbuf && *dump_ipnatctl_gtbuf != ' ')
		dump_ipnatctl_gtbuf++;
	if (*dump_ipnatctl_gtbuf) {
		*dump_ipnatctl_gtbuf=0;
		dump_ipnatctl_gtbuf++;
	}
	// fprintf(stderr,"TAG: %s\n",tag);
	return tag;
}

#define xerr(err) fprintf(stderr,"ERROR (%s): %s\n",err,xbuf);

int dump_ipnatctl_rule(char * buf) {
	char source[256]="",dest[256]="",prot[256]="";
	char btype[256]="",tto[256]="",map[256]="";
	char sport[256]="",dport[256]="",toports[256]="";
	char *tag,xbuf[256]; int n;
	
	dump_ipnatctl_gtbuf=buf;
	strcpy(xbuf,buf);
	
	strcpy(map,dump_ipnatctl_gettag());
	strcpy(btype,dump_ipnatctl_gettag());
	sscanf(dump_ipnatctl_gettag(),"%[^-]->%s",source,dest);
	
	tag=dump_ipnatctl_gettag();
	
	if ( sscanf(tag,"proto=%d",&n) == 1 ) {
		if (n == 1) strcpy(prot,"icmp");
		else if (n == 6) strcpy(prot,"tcp");
		else if (n == 17) strcpy(prot,"udp");
		else sprintf(prot,"%d",n);
		tag=dump_ipnatctl_gettag();
	}

	if ( sscanf(tag,"dstpt=%s",dport) == 1 ) tag=dump_ipnatctl_gettag();
	if ( sscanf(tag,"srcpt=%s",sport) == 1 ) tag=dump_ipnatctl_gettag();
	
	if ( strcmp(tag,"TO:") ) { xerr("No 'TO:'"); return 1; }
	tag=dump_ipnatctl_gettag();
	
	if ( *tag >= '0' && *tag <= '9' ) {
		strcpy(tto,tag);
		tag=dump_ipnatctl_gettag();
	}
	
	if ( !strcmp(tag,"ports") ) {
		strcpy(toports,dump_ipnatctl_gettag());
		tag=dump_ipnatctl_gettag();
	}
	
	if ( *tag ) { xerr("Tags left"); return 1; }
	
	printf("ipnatctl -I");
	if ( strcmp(source,"0.0.0.0/0") ) printf(" -s %s",source);
	if ( strcmp(dest,"0.0.0.0/0") )   printf(" -d %s",dest);
	if ( *prot ) printf(" -p %s",prot);
	if ( *sport ) printf(" --sport %s",sport);
	if ( *dport ) printf(" --dport %s",dport);
	if ( *toports ) printf(" --to-ports %s",toports);
	
	if ( !strcmp(btype,"[SRC]") ) printf(" -b source");
	else if ( !strcmp(btype,"[DST]") ) printf(" -b dest");
	else { xerr("Illegal binding type"); return 1; }
	
	if ( *tto ) printf(" -t %s",tto);
	if ( strcmp(map,"generic") ) printf(" -m %s",map);
	
	printf("\n");
	return 0;
}

int dump_ipnatctl_main(int argc, char ** argv) {
	FILE * f;  char buf[1024];

	if ( argc==3 && !strcmp(argv[2],"down") ) {
		printf("ipnatctl -F ; ipnatctl -F\n"); return 0;
	} else if ( argc!=3 || strcmp(argv[2],"up") ) {
		fprintf(stderr,"Usage: %s %s < up | down >\n",argv[0],argv[1]);
		return 1;
	}

	f=popen("ipnatctl -L -n","r");
	while ( xfgets(buf,1024,f) ) {
		if (dump_ipnatctl_rule(buf)) return 1;
	}
	fclose(f);
	
	return 0;
}
