#include <stdio.h>
#include <string.h>

void proc_para(char *s, char *nam) {
	char *c,*c2;
	
	// Remove blanks from the end of the string
	for (c=s+strlen(s); c>=s; *(c--)=0)
		if (*c!=' ' && *c) break;
	
	// Remove blanks from the begin of the string
	for (c=s; *c==' '; c++) ;
	if (c!=s) for (c2=s; *(c-1); c++,c2++) *c2=*c;
	
	// If it starts with a '!' - add a space after it.
	if (strcmp(nam,"opt") && s[0]=='!' && s[1]!=' ') {
		for (c=s+strlen(s); c>s; *(c+1)=*(c--)) ;
		s[1]=' ';
	}
}

char * xfgets(char *s, int size, FILE *stream) {
	char *rc,*nl;
	bzero(s,size);
	rc=fgets(s,size-1,stream);
	while (rc && (nl=strchr(rc,'\n')) ) *nl=' ';
	return rc;
}

char * get_non_blank(char *s) {
	int c;
	for (c=0; s[c]; c++)
		if (s[c]!=' ') return s+c;
	return NULL;
}

char * skip_words(char *s, int c) {
	while (*s==' ') s++;
	while (c-- > 0) {
		while (*s && *s!=' ') s++;
		while (*s==' ') s++;
	}
	return s;
}

/*  The extended target 'LOG'.
 */
#define IPT_LOG_TCPSEQ          0x01    /* Log TCP sequence numbers */
#define IPT_LOG_TCPOPT          0x02    /* Log TCP options */
#define IPT_LOG_IPOPT           0x04    /* Log IP options */
int extra_LOG(char *s) {
	char *xpos,*pos=s+4;
	char prefix[256];
	int i;
	if (strncmp(s,"LOG ",4)) return 0;
	while ( (pos=get_non_blank(xpos=pos)) != NULL ) {
		if ( sscanf(pos,"flags %d",&i) == 1) {
			if (i & IPT_LOG_TCPSEQ) printf(" --log-tcp-sequence");
			if (i & IPT_LOG_TCPOPT) printf(" --log-tcp-options");
			if (i & IPT_LOG_IPOPT) printf(" --log-ip-options");
			pos=skip_words(pos,2);
		} else
		if ( sscanf(pos,"level %d",&i) == 1) {
			printf(" --log-level %d",i);
			pos=skip_words(pos,2);
		} else
		if ( sscanf(pos,"prefix `%[^']'",prefix) == 1) {
			printf(" --log-prefix '%s'",prefix);
			pos+=strlen("prefix ''")+strlen(prefix);
		} else
		    break;
	}
	memset(s,' ',xpos-s);
	return 1;
}

/*  The extended target 'QUEUE'.
 */
int extra_QUEUE(char *s) {
	int markval;
	if (sscanf(s,"QUEUE mark %d",&markval) != 1) return 0;
	printf(" --mark %d",markval);
	memset(s,' ',(index(s+11,' ')-s));
	return 1;
}

/*  The extended match 'icmp'.
 */
int extra_icmp(char *s) {
	int icmptype;
	int gotya=0;
	if (sscanf(s,"icmp type %d",&icmptype) == 1)
		{ printf(" --icmp-type %d",icmptype); gotya=1; }
	if (sscanf(s,"icmp !type %d",&icmptype) == 1)
		{ printf(" --icmp-type ! %d",icmptype); gotya=1; }
	if (gotya)
		memset(s,' ',skip_words(s,3)-s);
	return gotya;
}

/*  The extended match 'limit'.
 */
int extra_limit(char *s) {
	char avg[50],burst[50];
	if (sscanf(s,"limit: avg %s burst %s",avg,burst) != 2) return 0;
	printf(" -m limit --limit %s --limit-burst %s",avg,burst);
	memset(s,' ',skip_words(s,5)-s);
	return 1;
}

/*  The extended match 'mac'.
 */
int extra_mac(char *s) {
	char macaddr[256];
	if (sscanf(s,"MAC %s",macaddr) != 1) return 0;
	proc_para(macaddr,"macaddr");
	printf(" -m mac --mac %s",macaddr);
	memset(s,' ',(index(s+4,' ')-s));
	return 1;
}

/*  The extended match 'multiport'.
 */
int extra_multiport(char *s) {
	char s1[256],s2[256];
	if (sscanf(s,"multiport %s %s",s1,s2) != 2) return 0;
	printf(" -m multiport --%s %s",s1,s2);
	memset(s,' ',skip_words(s,3)-s);
	return 1;
}

/*  The extended match 'state'.
 */
int extra_state(char *s) {
	char str[256];
	if (sscanf(s,"state %s",str) != 1) return 0;
	printf(" -m state --state %s",str);
	memset(s,' ',(index(s+6,' ')-s));
	return 1;
}

/*  The extended match 'tcp'.
 */
int extra_tcp_hex2tcpflag(char *frm, char *to) {
	int val;
	char str[256]="";
	if (sscanf(frm,"0x02%x",&val) != 1) return 0;
#define xxx(a,b) if ( (val&b) == b ) { val&=(~b); strcat(str,"," a); }
	xxx( "ALL", 0x3F );
	xxx( "URG", 0x20 );
	xxx( "ACK", 0x10 );
	xxx( "PSH", 0x08 );
	xxx( "RST", 0x04 );
	xxx( "SYN", 0x02 );
	xxx( "FIN", 0x01 );
#undef xxx
	if (val) return 0;
	if (str[0]) strcpy(to,str+1);
	else strcpy(to,"NONE");
	return 1;
}
int extra_tcp(char *s) {
	char *xpos,*pos=s+4;
	char ch,str1[256],str2[256];
	if (strncmp(s,"tcp ",4)) return 0;
	while ( (pos=get_non_blank(xpos=pos)) != NULL ) {
		if ( sscanf(pos,"Flags:%[^/]/%s",str1,str2) == 2) {
			if (!strcmp(str1,"0x0216") &&
			    !strcmp(str2,"0x022"))
				printf(" --syn");
			else if (!strcmp(str1,"!0x0216") &&
			    !strcmp(str2,"0x022"))
				printf(" ! --syn");
			else {
				extra_tcp_hex2tcpflag(str1,str1);
				extra_tcp_hex2tcpflag(str2,str2);
				printf(" --tcp-flags %s %s",str1,str2);
			}
			pos=skip_words(pos,1);
		} else
		if ( sscanf(pos,"%cpts:%s",&ch,str1) == 2 ||
		     sscanf(pos,"%cpt:%s",&ch,str1) == 2) {
			proc_para(str1,"tcp_port");
			printf(" --%cport %s",ch,str1);
			pos=skip_words(pos,1);
		} else
		if ( sscanf(pos,"option=%s",str1) == 1) {
			proc_para(str1,"tcp_option");
			printf(" --tcp-option %s",str1);
			pos=skip_words(pos,1);
		} else
		    break;
	}
	memset(s,' ',xpos-s);
	return 1;
}

/*  The extended match 'udp'.
 */
int extra_udp(char *s) {
	char *xpos,*pos=s+4;
	char ch,str[256];
	if (strncmp(s,"udp ",4)) return 0;
	while ( (pos=get_non_blank(xpos=pos)) != NULL ) {
		if ( sscanf(pos,"%cpts:%s",&ch,str) == 2 ||
		     sscanf(pos,"%cpt:%s",&ch,str) == 2) {
			proc_para(str,"udp_port");
			printf(" --%cport %s",ch,str);
			pos=skip_words(pos,1);
		} else
		    break;
	}
	memset(s,' ',xpos-s);
	return 1;
}


int dump_iptables_main(int argc, char ** argv) {
	FILE * f;
	char chain[255],policy[255];
	char buf[1024],*extra;
	
	if ( argc==3 && !strcmp(argv[2],"down") ) {
		printf("iptables -F ; iptables -X ; iptables -Z ; ");
		printf("iptables -P INPUT ACCEPT\n");
		printf("iptables -P FORWARD DROP ; ");
		printf("iptables -P OUTPUT ACCEPT\n");
		return 0;
	} else if ( argc!=3 || strcmp(argv[2],"up") ) {
		fprintf(stderr,"Usage: %s %s < up | down >\n",argv[0],argv[1]);
		return 1;
	}

	/*
	 *  Create non-builtin Chains and set default policies
	 */
	f=popen("iptables -L -n","r");
	while ( fgets(buf,255,f) )
	  if ( sscanf(buf,"Chain %s (%*s %[^)]",chain,policy) == 2 ) {
		if ( strcmp(chain,"INPUT") && strcmp(chain,"FORWARD") &&
		    strcmp(chain,"OUTPUT") )
			printf("iptables -N %s\n",chain);
		else
			printf("iptables -P %s %s\n",chain,policy);
	  }
	fclose(f);
	
	/*
	 *  Create rules
	 */
	f=popen("iptables -L -n -v","r");
	while ( xfgets(buf,1024,f) ) {
#define xxx(a,b,c) char a[(c-b)+3]
		xxx(pkts,0,4);		xxx(bytes,5,10);
		xxx(target,11,21);	xxx(prot,22,26);
		xxx(opt,27,30);		xxx(tos,31,35);
		xxx(in,36,42);		xxx(out,43,50);
		xxx(source,51,71);	xxx(dest,72,91);
#undef xxx
		if (get_non_blank(buf) == NULL) continue;
		if (!strncmp(buf," pkts bytes target",18)) continue;
		if (sscanf(buf,"Chain %s ",chain) == 1) continue;
#define xxx(a,b,c) memcpy(a,buf+b,(c-b)+1); a[(c-b)+1]=0; \
                   proc_para(a,#a); memset(buf+b,' ',(c-b)+1)
		xxx(pkts,0,4);		xxx(bytes,5,10);
		xxx(target,11,21);	xxx(prot,22,26);
		xxx(opt,27,30);		xxx(tos,31,35);
		xxx(in,36,42);		xxx(out,43,50);
		xxx(source,51,71);	xxx(dest,72,91);
#undef xxx
		printf("iptables -A %s",chain);
		if (target[0]) printf(" -j %s",target);
		if (prot[0] && strcmp(prot,"all")) printf(" -p %s",prot);
		if (opt[1] == 'f') printf("%s -f",opt[0]=='!'?" !":"");
		if (tos[0] != '*' && strcmp(tos,"any")) printf(" -t %s",tos);
		if (in[0]  && in[0]!='*')  printf(" -i %s",in);
		if (out[0] && out[0]!='*') printf(" -o %s",out);
		if (source[0] && strcmp(source,"0.0.0.0/0"))
			printf(" -s %s",source);
		if (dest[0]   && strcmp(dest,"0.0.0.0/0"))
			printf(" -d %s",dest);
		while ( (extra=get_non_blank(buf)) != NULL) {
			if ( extra_LOG(extra)       ) continue;
			if ( extra_QUEUE(extra)     ) continue;
			if ( extra_icmp(extra)      ) continue;
			if ( extra_limit(extra)     ) continue;
			if ( extra_mac(extra)       ) continue;
			if ( extra_multiport(extra) ) continue;
			if ( extra_state(extra)     ) continue;
			if ( extra_tcp(extra)       ) continue;
			if ( extra_udp(extra)       ) continue;
			break;
		}
		printf("\n");
		if (extra != NULL) {
			fprintf(stderr,"\n[ERROR] Not parsed: %s\n",extra);
			return 1;
		}
	}
	fclose(f);
	
	return 0;
}
