#include <stdio.h>
#include <errno.h>
#include <error.h>
#include <string.h>

int dump_modules_main(int argc, char ** argv) {
	FILE *f;
	int c,c2,modoptnr=0,up=0;
	
	char buf[256],modules[256][256];
	char modopt_nam[256][256],modopt_val[256][256];
	
	if ( (argc==3 || argc==4) && !strcmp(argv[2],"up") ) up=1;
	else if ( (argc==3 || argc==4) && !strcmp(argv[2],"down") ) up=0;
	else {
		fprintf(stderr,"Usage: %s %s < up | down > "
		        "[ old-dump ]\n",argv[0],argv[1]);
		return 1;
	}
	
	if (argc==4) {
		f=fopen(argv[3],"rt");
		if (!f) error(1,errno,"Open %s",argv[3]);
		for (buf[255]=c=0; fgets(buf,255,f); c++) {
			if (strncmp(buf,"insmod ",7)) { c--; continue; }
			sscanf(buf,"insmod %s %[^\n]",
			       modopt_nam[c],modopt_val[c]);
		}
		modoptnr=c;
		fclose(f);
	}
	
	f=fopen("/proc/modules","rt");
	if (!f) error(1,errno,"Open /proc/modules");
	for (buf[255]=c=0; fgets(buf,255,f); c++) {
		sscanf(buf,"%s",modules[c]);
		if (!up) printf("rmmod %s\n",modules[c]);
	}
	pclose(f);
	if (up)
	  while (c--) {
		printf("insmod %s",modules[c]);
		for (c2=modoptnr-1; c2>0; c2--)
			if (!strcmp(modules[c],modopt_nam[c2]))
				{ printf(" %s",modopt_val[c2]); break; }
		printf("\n");
	  }
	return 0;
}
