#include <stdio.h>
#include <dirent.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <error.h>
#include <errno.h>
#include <ctype.h>
#include <stdlib.h>

#define xerr(x, args...)  error(1,errno,__FILE__ ":%d: " x,__LINE__,##args)

#if 0
#  define debug(fmt,args...)  fprintf(stderr,"DEBUG: " fmt "\n",##args)
#else
#  define debug(fmt,args...)
#endif

struct proc_ent {
	char * pe_fn;
	char * pe_old;
	char * pe_new;
	struct proc_ent * pe_next;
};

struct proc_ent * proc_list = NULL;

void add_proc_ent(int isnew, char * fn, char * data) {
	struct proc_ent * this_ent;
	char * data2;
	
	this_ent = proc_list;
	while ( this_ent != NULL ) {
		if ( !strcmp(this_ent->pe_fn,fn) ) break;
		this_ent=this_ent->pe_next;
	}
	
	if ( this_ent == NULL ) {
		this_ent=malloc(sizeof(struct proc_ent));
		if (!this_ent) xerr("malloc(%ld)",(long)sizeof(struct proc_ent));
		this_ent->pe_fn=malloc(strlen(fn)+1);
		if (!this_ent) xerr("malloc(%ld)",(long)strlen(fn)+1);
		strcpy(this_ent->pe_fn,fn);
		this_ent->pe_old=this_ent->pe_new=NULL;
		this_ent->pe_next=proc_list;
		proc_list=this_ent;
	}
	
	data2=malloc(strlen(data)+1); strcpy(data2,data);
	if (isnew) this_ent->pe_new=data2;
	else this_ent->pe_old=data2;
}

void add_new_proc_ent(char * fn) {
	FILE * f;
	char * txtend;
	int ch;

	static char * txt = NULL;
	static size_t txtsize=0;
	
	debug("Reading file '%s' ...",fn);
	
	f=fopen(fn,"rt");
	if (!f) xerr("fopen(%s)",fn);
	if (txt) txt[0]=0;
	while ( (ch=fgetc(f)) != EOF ) {
		if ( !txtsize || strlen(txt)+50 < txtsize ) {
			txt=realloc(txt,txtsize+100);
			if (!txt) xerr("realloc(%ld)",(long)(txtsize+100));
			if (!txtsize) txt[0]=0;
			txtsize+=100;
		}
		txtend=txt+strlen(txt);
		if (ch == '\n') sprintf(txtend,"\\n");
		else if (ch == '\\') sprintf(txtend,"\\\\");
		else if (ch == '\'') sprintf(txtend,"\\047");
		else if ( !isprint(ch) && ch!='\t' ) sprintf(txtend,"\\%03o",ch);
		else sprintf(txtend,"%c",(char)ch);
	}
	fclose(f);
	add_proc_ent(1,fn,txt);

	debug("Reading file '%s' finished",fn);
}

void scan_proc(char * dirname) {
	struct dirent * dent;
	struct stat filestat;
	char * newfn;
	DIR * d;

	debug("Scanning directory '%s' ...",dirname);
	
	while (dirname[0] && dirname[strlen(dirname)-1]=='/')
		dirname[strlen(dirname)-1]=0;
	if (!dirname[0]) return;
	
	newfn=malloc(strlen(dirname)+NAME_MAX+1);
	if (!newfn) xerr("malloc(%ld)",(long)(strlen(dirname)+NAME_MAX+1));

	d=opendir(dirname);
	if (!d) xerr("opendir(%s)",dirname);
	while ( (dent=readdir(d)) != NULL ) {
		// skip '.' and '..'
		if ( !strcmp(dent->d_name,".") ||
		     !strcmp(dent->d_name,"..") ) continue;
		// skip process dirs
		if ( !strcmp(dirname,"/proc") ) {
			int c,isint=1;
			for (c=0; dent->d_name[c]; c++)
			    if ( !isdigit(dent->d_name[c]) ) isint=0;
			if (isint) continue;
		}
		sprintf(newfn,"%s/%s",dirname,dent->d_name);
		if ( lstat(newfn,&filestat) ) xerr("lstat(%s)",newfn);
		if ( S_ISDIR(filestat.st_mode) ) scan_proc(newfn);
		if ( S_ISREG(filestat.st_mode) && (filestat.st_mode&0222) &&
		     (filestat.st_mode&0444) ) add_new_proc_ent(newfn);
	}
	closedir(d);

	debug("Scanning directory '%s' finished",dirname);
}

void read_old_line(char * line) {
	char *opt,*data,*fn;
	int size,ok=0;
	
	size=strlen(line)+1;
	if ( (opt=malloc(size))  == NULL ) xerr("malloc(%d)",size);
	if ( (data=malloc(size)) == NULL ) xerr("malloc(%d)",size);
	if ( (fn=malloc(size))   == NULL ) xerr("malloc(%d)",size);
	
	opt[0]=data[0]=fn[0]=0;
	
	if ( sscanf(line,"echo -%s '%[^']' > %s",opt,data,fn) == 3 ) ok=1;
	if ( sscanf(line,"echo     '%[^']' > %s",    data,fn) == 2 ) ok=1;
	if ( sscanf(line,"echo -%s ''      > %s",opt,     fn) == 2 ) ok=1;
	if ( sscanf(line,"echo     ''      > %s",         fn) == 1 ) ok=1;
	
	if (!ok) {
		fprintf(stderr,"Error: Can't parse this line: %s\n",line);
		exit(1);
	}
	
	if ( strchr(opt,'n') == NULL ) strcat(data,"\\n");
	
	add_proc_ent(0,fn,data);
}

void read_old_file(char * fn) {
	FILE *f;
	char buf[100];
	char * line;

	buf[99]=0;
	line=NULL;
	
	f=fopen(fn,"rt");
	if (!f) xerr("fopen(%s)",fn);
	while ( fgets(buf,99,f) != NULL ) {
		if (!line) {
			line=malloc(strlen(buf)+1);
			if (!line) xerr("malloc(%ld)",(long)(strlen(buf)+1));
			strcpy(line,buf);
		} else {
			line=realloc(line,strlen(line)+strlen(buf)+1);
			if (!line) xerr("realloc(%ld)",(long)(strlen(line)+strlen(buf)+1));
			strcat(line,buf);
		}
		if (line[0] && line[strlen(line)-1]=='\n') {
			read_old_line(line);
			free(line); line=NULL;
		}
	}
	fclose(f);
}

int dump_proc_main(int argc, char ** argv) {
	char * txt;
	char opte,optn;
	
	if (argc > 4 || argc < 3 || argv[2][0]=='-') {
		fprintf(stderr,"Usage: %s %s path [ old-dump ]\n",
		               argv[0],argv[1]);
		return 1;
	}
	
	if (argc == 4) read_old_file(argv[3]);
	
	scan_proc(argv[2]);
	
	while ( proc_list != NULL ) {
	  if (proc_list->pe_new && (!proc_list->pe_old ||
	      strcmp(proc_list->pe_new,proc_list->pe_old))) {
		txt=proc_list->pe_new;
		opte=optn=1;
		if ( strlen(txt)>1 && !strcmp("\\n",txt+(strlen(txt)-2)))
			{ txt[strlen(txt)-2]=0; optn=0; }
		if ( strchr(txt,'\\') == NULL) opte=0;
		printf("echo%s%s%s '%s' > %s\n",opte||optn?" -":"",
		       opte?"e":"",optn?"n":"",txt,proc_list->pe_fn);
	  }
	  proc_list = proc_list->pe_next;
	}
	
	return 0;
}
