#include <stdio.h>
#include <string.h>

int dump_route_main(int argc, char ** argv) {
	FILE *f;
	
	int up=0;
	
	char buf[256],dest[256],gw[256];
	char mask[256],dev[256],flags[256];
	int mss,win,irtt;
	
	buf[255]=dest[255]=gw[255]=0;
	mask[255]=dev[255]=flags[255]=0;
	mss=win=irtt=0;
	
	if ( argc==3 && !strcmp(argv[2],"up") ) up=1;
	else if ( argc==3 && !strcmp(argv[2],"down") ) up=0;
	else {
		fprintf(stderr,"Usage: %s %s < up | down >\n",argv[0],argv[1]);
		return 1;
	}
	
	/*
	 *  Dump the IPv4 Routing table
	 */
	f=popen("route -A inet -n -e","r");
	fgets(buf,255,f); fgets(buf,255,f); /* 2 Header Lines */
	while ( fscanf(f,"%s %s %s %s %d %d %d %s",
	               dest,gw,mask,flags,&mss,&win,&irtt,dev) == 8 ) {
		if ( strchr(flags,'R') || strchr(flags,'M') ||
		     strchr(flags,'D') ) continue;
		printf("route -A inet %s ",up?"add":"del");
		if ( strchr(flags,'H') ) printf("-host %s ",dest);
		else printf("-net %s netmask %s ",dest,mask);
		if ( strchr(flags,'G') ) printf("gw %s ",gw);
		if ( mss>63 && up ) printf("mss %d ",mss);
		if ( win && up ) printf("window %d ",win);
		if ( irtt && up ) printf("irtt %d ",irtt);
		if ( strchr(flags,'!') ) printf("reject ");
		printf("dev %s\n",dev);
	}
	pclose(f);
	return 0;
}
