#!/bin/sh

iptables -A FORWARD -s 1.2.30.40 -f -j LOG
iptables -A FORWARD -s ! 1.2.3.4 -j LOG --log-level 2 --log-tcp-sequence
iptables -A FORWARD -d 1.2.30.40 -j LOG --log-tcp-options --log-prefix 'asd'
iptables -A FORWARD -d ! 1.2.3.4 ! -f -j LOG --log-ip-options

iptables -A FORWARD -p ! udp -j QUEUE --mark 25

iptables -A FORWARD -i eth0 -p icmp -s 2.3.4.5 --icmp-type parameter-problem
iptables -A FORWARD -o eth0 -p icmp -s 2.3.4.5 --icmp-type ! echo-request

iptables -A FORWARD -t 25 -m limit --limit 234/day --limit-burst 23

iptables -A FORWARD -i ! eth0 -m mac --mac 00:10:5A:30:4A:60
iptables -A FORWARD -o ! eth0 -m mac --mac ! 00:A0:24:44:B0:7A

iptables -A FORWARD -p tcp -m multiport --sports 10,20,30
iptables -A FORWARD -p tcp -m multiport --dports 40,50,60
iptables -A FORWARD -p udp -m multiport --ports  70,80,90

iptables -A FORWARD -m state --state RELATED,ESTABLISHED
iptables -A FORWARD -m state ! --state INVALID,NEW

iptables -A FORWARD -p tcp --sport 1024:2048 --dport 80 --syn
iptables -A FORWARD -p tcp --tcp-flags SYN,RST,ACK SYN,ACK --tcp-option ! 5
iptables -A FORWARD -p tcp --dport ! 20:30 ! --syn

iptables -A FORWARD -p udp --dport 50 --sport ! 20:30
