
#define _GNU_SOURCE

#include <string.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>

char * get_realname(char * origname) {
	static char buf[512];
	char *file,odir[512];
	
	strcpy(buf,origname);
	do {
		if ( (file=strrchr(buf,'/')) == NULL ) return buf;
		*file=0;
	} while (!file[1]);
	file=origname + (file-buf);
	
	getcwd(odir,512); chdir(buf);
	getcwd(buf,512); strcat(buf,file);
	chdir(odir); return buf;
}

int dir_empty(char * nam) {
	struct dirent **namelist; int n;
	n = scandir(nam, &namelist, 0, alphasort);
	if (n < 0) perror("scandir");
	while (n--)
		if ( strcmp(namelist[n]->d_name,".") &&
		     strcmp(namelist[n]->d_name,"..") ) return 0;
	return 1;
}

int main() {
	char fn[512]; struct stat st;
	while (scanf("%*s %s",fn) == 1) {
		if ( !lstat(fn,&st) && ( !S_ISDIR(st.st_mode) ||
		     dir_empty(fn) ) ) puts(get_realname(fn));
	}
	return 0;
}
