
/* gcc command wrapper.
 *
 * Modified 1.7 version.
 *
 * Initial copy Ren Rebe <rene.rebe@gmx.net 2002-04-03
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/wait.h>
#include <libgen.h>
#include <fnmatch.h>

#ifndef ENVPREFIX
#    error You must use -DENVPREFIX=".." when compiling this tool.
#endif

int debug=1;

/*
 *  Main function.
 */
int main(int argc, char ** argv) {
	char **newargv;
	int c1,c2,c3;
	char *delim, *optbuf, *wrdir;
	
	/* Calling the wrapper with an absolute path results in an
	   endless-loop. Use basename only to force a $PATH lookup. */
	argv[0] = basename(argv[0]);
	

	/*
	 *  Read prefix_WRAPPER_DEBUG
	 */

	if ( (delim=getenv(ENVPREFIX "_WRAPPER_SILENT")) != NULL &&
								delim[0] ) {
		debug = ! atoi(delim);
	}

	/*
	 * Run other wrappers first. They will re-start us.
	 */

	if ( (delim=getenv(ENVPREFIX "_WRAPPER_OTHERS")) != NULL &&
								delim[0] ) {
		newargv=malloc( sizeof(char*) * (argc+10) );
	
		newargv[0] = malloc(strlen(delim) + 1);
		strcpy(newargv[0], delim);
		delim = strchr(newargv[0], ':');
		if ( delim == NULL ) delim = "";
		else { *delim = 0; delim++; }
		setenv(ENVPREFIX "_WRAPPER_OTHERS", delim, 1);
		
		for (c1=0; c1 < argc; c1++)
			newargv[c1+1] = argv[c1];
		execvp(newargv[0], newargv);
		fprintf(stderr, ENVPREFIX "_WRAPPER: Can't execute "
				"'%s' -> abort.\n", newargv[0]);
		return 250;
	}
	
	/*
	 *  Detect loops
	 */
	
	if ( (delim=getenv(ENVPREFIX "_WRAPPER_NOLOOP")) != NULL &&
								delim[0]) {
		fprintf(stderr, ENVPREFIX
				"_WRAPPER: Detected loop! -> abort.\n");
		return 250;
	}
	setenv(ENVPREFIX "_WRAPPER_NOLOOP", "1", 1);

	
	/*
	 *  Remove the wrapper dir from PATH
	 */

	if ( (delim=getenv("PATH")) != NULL && delim[0] &&
	     (wrdir=getenv(ENVPREFIX "_WRAPPER_MYPATH")) != NULL &&
								wrdir[0] ) {
		optbuf = malloc( strlen(delim) + 1 );
		optbuf[0] = 0;
	
		if (debug)
			fprintf(stderr, "Old PATH: %s\n", delim);
	
		delim = strtok(delim, ":");
		while ( delim != NULL ) {
			if (strcmp(delim, wrdir)) {
				if (optbuf[0]) strcat(optbuf, ":");
				strcat(optbuf, delim);
			}
			delim = strtok(NULL, ":");
		}
		setenv("PATH", optbuf, 1);
	
		if (debug)
			fprintf(stderr, "New PATH: %s\n", optbuf);
	} else {
		fprintf(stderr, ENVPREFIX "_WRAPPER: $PATH or $" ENVPREFIX
		                "_WRAPPER_MYPATH is not set! -> abort.\n");
		return 250;
	}

	/*
	 *  Make sure that newargv[] is big enough
	 */
	
	/* start with argc */
	c1 = argc;

	/* add numbers of blanks in prefix_WRAPPER_INSERT */
	if ( (delim=getenv(ENVPREFIX  "_WRAPPER_INSERT")) != NULL )
		while (*delim) { if (*delim==' ') c1++; delim++; }

	/* add numbers of blanks in prefix_WRAPPER_APPEND */
	if ( (delim=getenv(ENVPREFIX  "_WRAPPER_APPEND")) != NULL )
		while (*delim) { if (*delim==' ') c1++; delim++; }

	/* add 10 to be sure (3 should be enough) */
	newargv=malloc( sizeof(char*) * (c1+10) );
	
	/* init newargv[] and c1 */
	newargv[0]=argv[0]; c1=1;


	/*
	 *  Copy options from prefix_WRAPPER_INSERT to newargv[]
	 */

	if ( (delim=getenv(ENVPREFIX  "_WRAPPER_INSERT")) != NULL ) {
		optbuf = malloc( strlen(delim) + 1 );
		strcpy(optbuf, delim);

		delim = strtok(optbuf, " ");
		while (delim != NULL) {
			if (delim[0]) {
			    if (debug) fprintf(stderr, "Insert: %s\n", delim);
			    newargv[c1++] = delim;
			}
			delim = strtok(NULL, " ");
		}
	}


	/*
	 *  Copy options from argv[] to newargv[] if they are not listed
	 *  in prefix_WRAPPER_REMOVE
	 */

	for (c2=1; c2<argc; c2++) {
		if ( (delim=getenv(ENVPREFIX  "_WRAPPER_REMOVE")) != NULL ) {
			optbuf = malloc( strlen(delim) + 1 );
			strcpy(optbuf, delim);

			delim = strtok(optbuf, " ");
			while (delim != NULL) {
				if ( delim[0] &&
				     !fnmatch(delim, argv[c2], 0) ) break;
				delim = strtok(NULL, " ");
			}
			free(optbuf);
		}
		if (delim == NULL) {
		    if (debug) fprintf(stderr, "Copy:   %s\n", argv[c2]);
		    newargv[c1++] = argv[c2];
		} else {
		    if (debug) fprintf(stderr, "Remove: %s\n", argv[c2]);
		}
	}


	/*
	 *  Copy options from prefix_WRAPPER_APPEND to newargv[]
	 */

	if ( (delim=getenv(ENVPREFIX  "_WRAPPER_APPEND")) != NULL ) {
		optbuf = malloc( strlen(delim) + 1 );
		strcpy(optbuf, delim);

		delim = strtok(optbuf, " ");
		while (delim != NULL) {
			if (delim[0]) {
			    if (debug) fprintf(stderr, "Append: %s\n", delim);
			    newargv[c1++] = delim;
			}
			delim = strtok(NULL, " ");
		}
	}
	

	/*
	 *  Use prefix_WRAPPER_FILTER if set and not ""
	 *
	 *  (Maybe we make a nice re-write of this code-block later.)
	 */

	if ( (delim=getenv(ENVPREFIX "_WRAPPER_FILTER")) != NULL && delim[0] ) {
	
		/* Open temp files. */
		char outfn[] = "/tmp/gccfilter_out.XXXXXX";
		char infn[] = "/tmp/gccfilter_in.XXXXXX";
		int outfd = mkstemp(outfn);
		int infd = mkstemp(infn);
	
		/* Create content of input file */
		for (c3=0; c3<c1; c3++) {
			write(infd, newargv[c3], strlen(newargv[c3]));
			write(infd, "\n", 1);
		}
		lseek(infd, 0, SEEK_SET);
	
		/* Run filter command with shell (sh -c xxx) */
		if (!fork()) {
			if (debug) fprintf(stderr, "Run Filter: %s\n", delim);
			dup2(infd,  0);  close(infd);
			dup2(outfd, 1);  close(outfd);
			execlp("sh", "sh", "-c", delim, NULL);
			fprintf(stderr, ENVPREFIX "_WRAPPER: Can't execute "
			                "'%s' with shell!\n", delim);
			return 1;
		}
		wait(NULL);  /* We don't expect any signals and have no */
		             /* other child processes. */
	
		/* Re-read parameter list. Don't free old stuff, we do an
		   exec() anyway ... */
		lseek(outfd, 0, SEEK_SET);
		/* Maximum on 1023 parameters, 1023 chars each. */
		newargv = malloc( sizeof(char*) * 1024 );
		for (c1=0; c1<1023; c1++) {
			newargv[c1] = malloc(1024);
			for (c2=0; c2<1023; c2++) {
				if (read(outfd, newargv[c1]+c2, 1) != 1)
						goto reread_file_finished;
				if (newargv[c1][c2] == '\n')
						{ newargv[c1][c2] = 0; break; }
			}
			newargv[c1] = realloc(newargv[c1],
			                      strlen(newargv[c1])+1);
		}
reread_file_finished:
	
		/* Close and remove temp files */
		close(outfd); unlink(outfn);
		close(infd);  unlink(infn);
	}


	/*
	 *  Run the new command
	 */
	
	if (debug) {
	  fprintf(stderr, "wrapped: ");
	  for (c3=0; c3<c1; c3++) fprintf(stderr, " %s", newargv[c3]);
	  fprintf(stderr, "\n");
	}
	
	newargv[c1]=NULL;
	execvp(newargv[0], newargv);
	
	fprintf(stderr, ENVPREFIX "_WRAPPER: Can't execute "
	                "'%s' -> abort.\n", newargv[0]);
	return 250;
}
