#!/bin/sh

KERNEL="$(ls $PWD/../../pkg-archive/linux-*.tar.bz2 | tail -1)"
LIST="$(ls $PWD/*.patch | tr '\n' ' ')"
DIFFSH="$PWD/new-patch.sh"

echo "---"
echo "--- KERNEL='$KERNEL'"
echo "--- LIST='$LIST'"
echo "---"

echo "--- Cleaning up ..."
rm -rf *.new /tmp/linux.new /tmp/linux.old /tmp/linux
cd /tmp
echo "--- Creating /tmp/linux.old ..."
tar xIf $KERNEL ; mv linux linux.old
echo "--- Creating /tmp/linux.new ..."
cp -a /tmp/linux.old /tmp/linux.new

for x in $LIST ; do
	echo "--- Patching $x (new) ..."
	cd /tmp/linux.new
	patch -Nlfp1 --backup-if-mismatch < $x || \
		{ echo "Patching $x (new) failed!" ; exit 1 ; }
	find -name '*.orig' -o -name '*~' | xargs rm -fv
	echo "--- Creating $x.new ..."
	cd /tmp ; sh $DIFFSH $x > $x.new
	if cmp -s $x $x.new ; then
	  echo "New version does not differ -> remove." ; rm -f $x.new
	else
	  echo "New version differs! (This program makes sense :-)"
	fi
	echo "--- Patching $x (old) ..."
	cd /tmp/linux.old
	if [ -f $x.new ] ; then
		patch -Nfp1 --no-backup-if-mismatch < $x.new || \
			{ echo "Patching $x.new (old) failed!" ; exit 1 ; }
	else
		patch -Nfp1 --no-backup-if-mismatch < $x || \
			{ echo "Patching $x (old) failed!" ; exit 1 ; }
	fi
done

echo "--- Cleaning up ..."
rm -rf /tmp/linux.new /tmp/linux.old /tmp/linux
echo "--- READY."
