#!/bin/sh
#
# This script disables drivers in the .config file which are known to
# be broken in the current kernel version.

rm -f /tmp/$$.sed

list="" # list like: CONFIG_NTFS_FS CONFIG_SCSI_CPQFCTS ...

for x ; do
    if [ -f "$x" ] ; then
	list="$list `tr ' ' '\t' < $x | cut -f1 | grep '^CONFIG_'`"
    fi
done

for x in $list
do
    echo "s,^$x=.\$,# $x is not set,;" >> /tmp/$$.sed
done

sed -f /tmp/$$.sed ; rm -f /tmp/$$.sed
