#!/bin/sh

perl -pe 'exit 0 if /^--- /' < $1
egrep '^(\+\+\+|---) linux/' $1 | sed 's,^... linux/,,' | \
sed 's,[^a-zA-Z0-9\./+,_-].*,,' | sort -u | \
while read fn ; do
	mkdir -p $(dirname linux.old/$fn)
	mkdir -p $(dirname linux.new/$fn)
	touch linux.old/$fn linux.new/$fn
	echo -e "--- linux/$fn\n+++ linux/$fn"
	diff -u linux.old/$fn linux.new/$fn | tail +3
done
