#!/bin/bash
#
# dRock Linux: /etc/init.d/master.sh
# Desc: init.d master script
#
# (C) JUN 2000 by V Ziegler <ziegler@informatik.hu-berlin.de>
#     MAR 2001 by Ren Rebe <rene.rebe@gmx.net>
#

info_message_color="\e[36m"
warn_message_color="\e[1;33m"
stat_message_color="\e[1m"
done_message_color="\e[32m"
fail_message_color="\a\e[1;31m"
message_end_color="\e[0m"

right_border="\e[222G\e[3D"
move_up="\e[1A"

done_message=${move_up}${right_border}${done_message_color}":-)"${message_end_color}
fail_message=${move_up}${right_border}${fail_message_color}":-("${message_end_color}


RESULT=${fail_message}

c_write ()
{
    echo -en ${info_message_color}$1${message_end_color}
}

c_writeln ()
{
    echo -e ${info_message_color}$1${message_end_color}
}

c_warn ()
{
    echo -e ${warn_message_color}$1${message_end_color}
}

usage_info () 
{
    USTRING="Usage: $0 {"
    SUSTRING=""
    test -n "${STARTABLE}" && USTRING=${USTRING}"start" && SUSTRING="|"
    test -n "${STOPABLE}" && USTRING=${USTRING}${SUSTRING}"stop" && SUSTRING="|"
    test -n "${STATUSAVAILABLE}" && USTRING=${USTRING}${SUSTRING}"status" && SUSTRING="|"
    if test -n "${STARTABLE}" && test -n "${STOPABLE}" ; then
	USTRING=${USTRING}"|restart|reload"
    else
	test -n "${CUSTOMRESTART}" && USTRING=${USTRING}${SUSTRING}"restart" && SUSTRING="|"
	test -n "${CUSTOMRELOAD}" && USTRING=${USTRING}${SUSTRING}"reload" && SUSTRING="|"

    fi
    echo ${USTRING}"}"
    exit 1
}

main ()
{
    case "$1" in
    start)
	test -n "${STARTABLE}" || usage_info
	start && RESULT=${done_message}
    ;;
    stop)
	test -n "${STOPABLE}" || usage_info
	stop && RESULT=${done_message}
    ;;
    status)
	test -n "${STATUSAVAILABLE}" || usage_info
	status && RESULT=""
    ;;
    reload)
	if test -n "${CUSTOMRELOAD}" ; then 
	    customreload && RESULT=${done_message}
	else
	    test -n "${STARTABLE}" && test -n "${STOPABLE}" || usage_info
	    if stop ; then
		echo -e ${done_message}
		start && RESULT=${done_message}
	    fi
	fi
    ;;
    restart)
	if test -n "${CUSTOMRESTART}" ; then 
	    customrestart && RESULT=${done_message}
	else
	    test -n "${STARTABLE}" && test -n "${STOPABLE}" || usage_info
	    if stop ; then
		echo -e ${done_message}
		start && RESULT=${done_message}
	    fi
	fi
    ;;
    *)
	usage_info
    ;;
    esac
    test -n "${RESULT}" && echo -e ${RESULT}
    test "${RESULT}" = "${done_message}"
    return $?	
}

# IMPORTANT NOTE!
# The last used print command before sub_exec _must_ end with a new line
# character. Use something like 'c_writeln', 'echo' or 'printf("%s\n", ...)'
#
sub_exec ()
{
    SUB_RESULT=${done_message}
    if [ "$1" = "-q" ]; then
	shift
	eval $@ >/dev/null 2>&1
    else
	eval $@
    fi
    SUB_RETVAL=$?
    test ${SUB_RETVAL} -eq 0 || SUB_RESULT=${fail_message}
    echo -e ${SUB_RESULT}
    return ${SUB_RETVAL}
}
