#!/bin/sh

bin_fhs='cat chgrp chmod chown cp date dd df dmesg echo ed false
         kill ln login ls mkdir mknod more mount mv ps pwd rm rmdir
         sed setserial sh stty su sync true umount uname
         tar gzip gunzip zcat cpio domainname hostname netstat ping
         sleep bzip2 bunzip2 bzcat'

bin_rock='bash ksh sleep sync sort xargs grep cut skill snice find'

sbin_fhs='clock getty init update mkswap swapon swapoff telinit
          fastboot fasthalt halt reboot shutdown ifconfig route
          fdisk fsck fsck.ext2 fsck.ext3 mkfs mkfs.ext2 badblocks dumpe2fs
          e2fsck mke2fs mklost+found tune2fs lilo ctrlaltdel kbdrate'

sbin_rock='devfsd'

if [ ! -z "$1" ] ; then
	for x in $bin_fhs $bin_rock ; do
		grep "bin/$x\$" $1 | sed 's,^,bin: ,'
	done
	for x in $sbin_fhs $sbin_rock ; do
		grep "bin/$x\$" $1 | sed 's,^,bin: ,'
	done
	exit
fi

for x in $bin_fhs $bin_rock ; do for y in usr/bin usr/sbin sbin ; do
	[ -e $y/$x ] && echo "Should be in /bin: $y/$x"
done ; done

for x in $sbin_fhs $sbin_rock ; do for y in usr/bin usr/sbin bin ; do
	[ -e $y/$x ] && echo "Should be in /sbin: $y/$x"
done ; done

for x in $bin_fhs $bin_rock ; do
	[ -e bin/$x ] || echo "Not found: bin/$x"
done

for x in $sbin_fhs $sbin_rock ; do
	[ -e sbin/$x ] || echo "Not found: sbin/$x"
done
