#!/usr/bin/perl -w

use strict;

my %bins;
my %infos;
my ($pkg,$fn);
my $first=1;

foreach (@ARGV) {
	if (not open(F,$_)) {
		warn "$0: $_: $!\n";
		next;
	}
	while (<F>) {
		chomp;
		/^(\S*):\s*(.*)/;
		($pkg,$fn)=($1,$2);
		next if $fn=~/^usr\/lib\/install-disk/;
		next if $pkg eq 'rock-debug';
		if (/.*(s?bin|usr\/games)\/([^\/]+)/) {
			$bins{$1}=$pkg;
		} elsif (/.*\/info\/([^\/]+)\.info/) {
			$infos{$1}=$pkg;
		}
	}
	close F;
}

foreach (sort keys %infos) {
	if (defined $bins{$_} and $infos{$_} ne $bins{$_}) {
		printf("| %-20s| %-20s| %-20s|\n",
                       "Name","info-package","bin-package") if $first;
		print "+---------------------+-----------" .
		      "----------+---------------------+\n" if $first;
		printf("| %-20s| %-20s| %-20s|\n",
                       $_,$infos{$_},$bins{$_});
		$first=0;
	}
}
