#!/usr/bin/perl -w

use strict;

my %bins;
my %mans;
my %mansecs;
my ($pkg,$fn);
my ($name,$sec);
my $first=1;

foreach (@ARGV) {
	if (not open(F,$_)) {
		warn "$0: $_: $!\n";
		next;
	}
	while (<F>) {
		chomp;
		/^(\S*):\s*(.*)/;
		($pkg,$fn)=($1,$2);
		next if $fn=~/^usr\/lib\/install-disk/;
		next if $pkg eq 'man-pages';
		next if $pkg eq 'rock-debug';
		if (/.*(s?bin|usr\/games)\/([^\/]+)/) {
			$bins{$1}=$pkg;
		} elsif (/.*\/man\/.*\/([^\/]+)\.([^\/\.]+)/) {
			($name,$sec)=($1,$2);
			next if $sec=~/[23]/;
			$mans{$1}=$pkg;
			$mansecs{$1}=$2;
		}
	}
	close F;
}

foreach (sort keys %mans) {
	if (defined $bins{$_} and $mans{$_} ne $bins{$_}) {
		printf("| %-5s| %-20s| %-20s| %-20s|\n","Sec",
                       "Name","man-package","bin-package") if $first;
		print "+------+---------------------+-----------" .
		      "----------+---------------------+\n" if $first;
		printf("| %-5s| %-20s| %-20s| %-20s|\n",
                       $mansecs{$_},$_,$mans{$_},$bins{$_});
		$first=0;
	}
}
