/*  btee.c, a buffered tee clone   -   written for ROCK Linux

    Copyright (C) 1998, 1999  Clifford Wolf

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define _GNU_SOURCE

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define BUFFER_SIZE 8*1024
static char buffer[BUFFER_SIZE];

#define EOT 004

int main(int argc, char ** argv) {
	int rc,mode,x;
	int pos=0,loop=1;
	
	if ( argc!=3 || (argv[1][0]!='a' && argv[1][0]!='t') ) {
		printf("Usage: %s {a|t} [file]\n",argv[0]);
		return 1;
	}
	
	if (argv[1][0]=='a')
		mode=O_WRONLY|O_CREAT|O_APPEND;
	else
		mode=O_WRONLY|O_CREAT|O_TRUNC;
	
	while (loop) {
		if (pos >= BUFFER_SIZE) {
			fprintf(stderr,"%s: Buffer is full -> drop data!\n",argv[0]);
			pos=0;
		}
		
		rc=read(0,buffer+pos,BUFFER_SIZE-pos);
		if (rc <= 0) return 0;
		for (x=0; x<rc; x++)
			if (buffer[pos+x]==EOT) { loop=0; rc=x; break; }
		if (rc>0) {
			write(1,buffer+pos,rc);
			pos+=rc;
			rc=open(argv[2],mode,0666);
			if (rc>=0) {
				write(rc,buffer,pos);
				close(rc);
				pos=0;
				mode=O_WRONLY|O_APPEND;
			}
		}
	}
	
	return 0;
}
