#!/bin/sh

# Init / Clean up
#
rm -rf /tmp/cv-$$.sh /tmp/cv-$$.dir
touch /tmp/cv-$$.sh || exit 1
mkdir /tmp/cv-$$.dir || exit 1

# Create download script
#
nr=0
{
	grep -h '^[^#]' pkg-archive/INDEX opt-archive/INDEX
	egrep -h '^# \[(D|DOWN|DOWNLOAD)\]' misc/ext-intern/*/*.ext | \
		sed 's,# \[[A-Z]*\] [^ ]* ,,' | grep -v ' intern://'
} | sort -u | {
	perl -pe "s!(\S+)\s*(.*)!perl -w ./scripts/checkver.pl \$1 \$2 > /tmp/cv-$$.dir/\$1.out &!" | \
	while read line ; do
		nr=`expr $nr + 1` ; echo -n "$nr " >&2
		if [ `expr $nr % 30` = 0 ] ; then
			echo 'sleep 3 ; echo -n "Waiting: " >&2 ; sleep 10'
			echo 'while nr=`fuser /tmp/cv-$$.dir/* | wc -l | tr -d " "` ; [ $nr -gt 15 ] ; do echo -n " $nr" >&2 ; sleep 3 ; done'
			echo 'echo " [* DOWNLOADING *]" >&2'
		fi
		echo $line
	done
} >> /tmp/cv-$$.sh

# Run Download Script
#
echo " [* DOWNLOADING *]" >&2
. /tmp/cv-$$.sh
sleep 3 ; echo -n "Waiting: " >&2 ; sleep 10

# Wait for the script to complete
#
while
	nr=`fuser /tmp/cv-$$.dir/* | wc -l | tr -d " "`
	[ $nr != 0 ]
do
	echo -n " $nr" >&2 ; sleep 3
done
echo " [* READY *]" >&2

# Create Output and clean up
#
ls /tmp/cv-$$.dir/* | sort | xargs cat
rm -rf /tmp/cv-$$.sh /tmp/cv-$$.dir
