#!/usr/bin/perl
#
# This is a replacement for the cpp to parse our architecture
# configs in arch-conf.
#
# Copyright (C) 2001 Ren Rebe <rene.rebe@gmx.net>
# LICENSE: GPL v.2 or on your option a newer version
#

use strict;

my @include_dirs;
my %open_files;

sub find_full_name {
  my ($file) = @_;
  
  if (-e $file) {
    return $file;
  }
  
  my $i = 0;
  while ($i <= $#include_dirs) {
    my $testname = "@include_dirs[$i]/$file";
    if (-e $testname) {
      return $testname;
    }
    $i += 1;
  }
  
  return "";
}

sub parse_file {
  my $file;

  ($file)= @_;
  
  if ($open_files{$file} ne "") {
    die "Recursion detected including this file: $file";
  }
  
  $open_files{$file} = "used";
  
  my $handle;
  open ($handle, $file) or die "File $file does not exist!";
  
  my $line;
  while ($line = <$handle>) {
    # print ("->>$line\n");
    if ($line =~ /\#include/) {
      # get include filename
      my @include_statement = split /\"|<|>/, $line;
      my $next_file = $include_statement[1];
      
      #if ($line =~ /<|>/) {
      # global include
      #}
      #elsif ($line =~ /\"/) {
      # local include
      #}
      #else {
      #die "do not not what kind of include this is: $line";
      #}
      
      my $found_file = find_full_name ($next_file);
      if ($found_file eq "") {
	die "included file not found: $next_file";
      }
      else {
	parse_file ($found_file);
      }
    }
    else {
      print ($line);
    }
  }
  
  $open_files{$file} = "";
  
  close ($handle);
}

# check for one argument
die "the includer needs at least one argument" if ($#ARGV == -1);
my $glfile;

# parse the remaining arguments
while (@ARGV) {
  my $temp = $ARGV[0];
  $ARGV = shift @ARGV;
  
  #print "parsing: $temp $#ARGV \n";
  
  if ($#ARGV + 1) {
    if ($temp =~ /-I/) {
      $temp =~ s/-I//;
      push @include_dirs, $temp;
    }
    else {
      die "unknown argument: $temp";
    }
  }
  else {
    $glfile = $temp;
  }
}

parse_file ($glfile);
