#
# The build script for ix86 PCs install disks
# (over-worked for dRock by Ren Rebe)
#

#global funtions
# create_fs_image src_dir block_count dest_file
create_fs_image () {
	echo "Creating (dumping) filesystem image ..."
	echo "  create_fs_image: $1 $2 $3 ..."
	
	if [ ".$1" == "." ] ; then
		echo "no source?"
		exit -1
	fi
	if [ ".$2" == "." ] ; then
		echo "no block count??"
		exit -2
	fi
	if [ ".$3" == "." ] ; then
		echo "no destination???"
		exit -3
	fi
	
	mkdir -p disk.mnt
	rm -rf disk.mnt/*

	du -c $1

	dd if=/dev/zero of=$tmpdev bs=1k count=$2
	mke2fs -m0 $tmpdev $2 ; mount $tmpdev disk.mnt
	cp -av $1/* disk.mnt
	umount disk.mnt ; dd if=$tmpdev bs=1k count=$2 | gzip -9 > $3
	du -sh $3
	
	echo "  cleanup ..."
	rm -rf disk.mnt/*
	rm -rf $1/*
	echo "... finished"
}

create_wrap_link () {
	echo "create_wrap: $1 ..."
	# if not normal file
	if [ ! -f "$2/$1" ] ; then
	  # maybe a symlink which can stay as it is
	  if [ ! -L "$2/$1" ] ; then
		echo "WARNING: $2/$1 does not exist - (Maintainer should clean up)!"
		return
	  fi
	fi
	
	dir=`dirname $3/$1`
	mkdir -p $dir
	mv -fv $2/$1 $dir
	
	# direct link for libs - src-wrap for binaries
	if [ `echo $1 | grep lib` ] ; then
		#echo "lib"
		ln -fvs /src/$1 $2/$1
	else
	 	#echo "bin"
		ln -fvs /sbin/src-wrap $2/$1
	fi
}

error_clean_up () {
	echo "error_clean_up called"
	umount $tmpdev || true
	losetup -d $tmpdev
	exit -1
}

# free the loop device on error
trap error_clean_up EXIT QUIT TERM KILL

###############################################################################

echo -e "\n **** Prepare creation of install floppies ****\n"

mkdir -p src/inst-disk
cd src/inst-disk
cp $sd_srcdir/intel/* .

dd if=/dev/zero of=buffer bs=1k count=4096 ; tmpdev=x
for x in /dev/loop/* ; do
	if [ $tmpdev = x ] ; then
		echo "Trying to use loopback dev $x ..."
		if losetup $x buffer ; then tmpdev=$x ; fi
	fi
done
if [ $tmpdev = x ] ; then
	echo "No free loopback device found. Abort." ; exit 1
fi
echo "Using loop device $tmpdev."
trap "losetup -d $tmpdev" 3 6 9 11 15

echo 'Extracting kernel and install-disk fs.'
tar xIf $sd_instdir/install-disks.tar.bz2
mv boot-disk/System.map .

rm -rf $base/rock-$arch-$rockver/wrapped
mkdir -p $base/rock-$arch-$rockver/wrapped

###############################################################################

echo 'Building custom binaries ...'

export PATH="$base/lib:$PATH"
confopt="--build=$build --host=$target"

export CC_WRAPPER_MYPATH="$base/lib"
export CC_WRAPPER_INSERT="-Os -fno-inline -pipe -s"
export CC_WRAPPER_REMOVE="-O -O[01] -g"
export CC_WRAPPER_APPEND="" CC_WRAPPER_FILTER="" CC_WRAPPER_OTHERS=""

export CC_WRAPPER_SILENT="0"
gcc --version
export CC_WRAPPER_SILENT="1"

echo " tar ..."
  tar xfI $base/pkg-archive/tar-1.13.tar.bz2
  cd tar-1.13
  for x in $base/pkg-config/tar/*.patch ; do
    if [ -f "$x" ] ; then
	echo "Applying patch $x ..."
	patch -bfp1 < "$x"
    fi
  done
  ./configure $confopt --disable-nls
  make > /dev/null
  du -h src/tar/ ; cp -vf src/tar ../install-disk/bin/tar
  rm -rf tar-1.13
cd ..

echo "  wget ..."
  tar xfI $base/pkg-archive/wget-1.8.1.tar.bz2
  cd wget-1.8.1
  ./configure $confopt --without-ssl --disable-opie --disable-digest --disable-debug --disable-nls
  make > /dev/null
  du -h src/wget ; cp -vf src/wget ../install-disk/bin/wget
  rm -rf wget-1.8.1
cd ..

echo "  bash ..."
  tar xfI $base/pkg-archive/bash-2.05a.tar.bz2
  cd bash-2.05a
  ./configure $confopt --disable-help-builtin --disable-progcomp --disable-nls
  make > /dev/null
  du -h bash ; cp -vf bash ../install-disk/bin/sh
  rm -rf bash-2.05a
cd ..

echo 'Creating temporary scratch point.'
mkdir disk.scratch ; mnt="`pwd`/disk.scratch"

echo 'Creating install-disk/sbin/modules'

cat > install-disk/sbin/modules << 'EOT'
#!/bin/sh

if [ ".$1" != ".pcmcia" -a ".$1" != ".net" -a ".$1" != ".scsi" ] ; then
	echo "Usage: $0 < pcmcia | net | scsi >"
	exit 1
fi

echo -n "Insert modules disk into /dev/floppy/0 and press [ENTER] .."
read x

if [ ! -d /lib/modules ] ; then
	mkdir -p /lib/modules
	mke2fs -vm0 /dev/rd/5 4096
	mount /dev/rd/5 /lib/modules
fi

mkdir -p /tmp/$$.mnt
mount -v -t ext2 -o ro /dev/floppy/0 /tmp/$$.mnt
cd /
tar xvfI /tmp/$$.mnt/mods-$1.tar.bz2
umount -v /dev/floppy/0
rmdir /tmp/$$.mnt
EOT
chmod +x install-disk/sbin/modules

###############################################################################

echo -e "\n **** Create 'root-disk.img' ****\n"

cp -a install-disk/* $mnt/

echo "moving/creating some the src-wrap space-saving ..."
for x in $mnt/lib/libssl* $mnt/lib/libcrypto* $mnt/lib/libnss* \
         $mnt/lib/libresolv* \
	 $mnt/bin/install_* \
         $mnt/bin/e2fsck $mnt/bin/tune2fs $mnt/bin/badblocks \
         $mnt/bin/sfdisk $mnt/bin/cfdisk \
         $mnt/bin/debugreiserfs $mnt/bin/reiserfsck $mnt/bin/mkreiserfs \
         $mnt/bin/wget $mnt/bin/route \
	 ; do
  create_wrap_link `echo $x | sed "s,$mnt/,,"` $mnt $base/rock-$arch-$rockver/wrapped
done
create_fs_image $mnt 4096 root-disk.img

###############################################################################

echo -e "\n **** Create 'boot-disk.img' ****\n"
#
dd if=/dev/zero of=$tmpdev bs=1k count=1440
mke2fs -m0 $tmpdev 1440 ; mount $tmpdev $mnt
cp -a boot-disk/* lilo-help.txt $mnt/
ln -sf boot-text.b $mnt/boot.b
tr '\n=\t-' '=\n\-\t' < lilo-conf-1.txt |
sed 's,\\=-*,,' | tr '\n=\t-' '=\n\-\t' > $mnt/lilo.conf
sed -e "s,/mnt/,$mnt/,; s,/dev/floppy/0,$tmpdev,;" \
	< $mnt/lilo.conf > lilo.conf.tmp
boot-disk/lilo -C lilo.conf.tmp ; rm lilo.conf.tmp
umount $mnt ; dd if=$tmpdev of=boot-disk.img bs=1k count=1440

###############################################################################

echo -e "\n **** Create 'modules-disk.img' ****\n"
#
if [ -f $sd_pkgdir/linux.tar.bz2 ]
then
	mkdir modules ; cd modules
	tar xIf $sd_pkgdir/linux.tar.bz2 lib/modules
	find lib/ -name "modules.*" | xargs rm -f
	find lib/ -type f | xargs strip --strip-debug --strip-unneeded
	
	echo "  creating PCMCIA package ..."
	tar cIf ../mods-pcmcia.tar.bz2  lib/modules/*/pcmcia
	echo "  creating NET package ..."
	tar cIf ../mods-net.tar.bz2     lib/modules/*/kernel/drivers/net
	echo "  creating SCSI package ..."
	tar cIf ../mods-scsi.tar.bz2    lib/modules/*/kernel/drivers/scsi
	
	echo "  cleaup for min-SCSI package ..."
	# some are not in wide use, for the same device or for ISA cards
	rm -vrf lib/modules/*/kernel/drivers/scsi/{sg,st,sr_mod,sd_mod}.o
	rm -vrf lib/modules/*/kernel/drivers/scsi/{scsi_debug,osst}.o
	rm -vrf lib/modules/*/kernel/drivers/scsi/pcmcia
	rm -vrf lib/modules/*/kernel/drivers/scsi/{sym53c8xx_2,aacraid}
	rm -vrf lib/modules/*/kernel/drivers/scsi/{53c7\,8xx,sym53c416}.o
	rm -vrf lib/modules/*/kernel/drivers/scsi/{aic7xxx_old,NCR53c406a}.o
	rm -vrf lib/modules/*/kernel/drivers/scsi/{BusLogic,qlogicfc}.o
	rm -vrf lib/modules/*/kernel/drivers/scsi/{qlogicfas,qlogicisp}.o
	rm -vrf lib/modules/*/kernel/drivers/scsi/{ide-scsi,aha*}.o
	rm -vrf lib/modules/*/kernel/drivers/scsi/{AM53C974,eata*}.o
	rm -vrf lib/modules/*/kernel/drivers/scsi/{Aqla1280,g_NCR5380}.o
	rm -vrf lib/modules/*/kernel/drivers/scsi/{3w-xxxx,imm,ppa}.o
	echo "  creating min-SCSI package ..."
	tar cvfI ../min-mods-scsi.tar.bz2  lib/modules/*/kernel/drivers/scsi
	
	cd .. ; rm -rf modules
	
	echo "  creating modules-disk.img ..."
	cp mods-pcmcia.tar.bz2 mods-net.tar.bz2 min-mods-scsi.tar.bz2 $mnt/
        create_fs_image $mnt 1440 modules-disk.img
fi

###############################################################################

echo -e "\n **** Create 'root-kombo.img' ****\n"

cp -a install-disk/* $mnt/

echo "moving/creating some the src-wrap space-saving ..."
for x in $mnt/lib/libssl* $mnt/lib/libcrypto* $mnt/lib/libnss* \
         $mnt/lib/libresolv* $mnt/bin/install_* \
         $mnt/bin/e2fsck $mnt/bin/tune2fs $mnt/bin/badblocks \
         $mnt/bin/sfdisk $mnt/bin/cfdisk \
         $mnt/bin/debugreiserfs $mnt/bin/reiserfsck $mnt/bin/mkreiserfs \
         $mnt/bin/wget $mnt/bin/route $mnt/bin/ifconfig ; do
  create_wrap_link `echo $x | sed "s,$mnt/,,"` $mnt $base/rock-$arch-$rockver/wrapped
done


rm -rf files[.-]* $mnt/etc/hosts $mnt/usr/share/terminfo/[!l]

if [ -f min-mods-scsi.tar.bz2 ] ; then
	cp min-mods-scsi.tar.bz2 $mnt/min-mods-scsi.tar.bz2
	cat > $mnt/etc/setup-mods-scsi.sh <<- EOT
		echo 'Extracting SCSI modules ...'
		mkdir -p /lib/modules ; mke2fs -q /dev/rd/5
		mount -v /dev/rd/5 -t ext2 /lib/modules
		tar xIf /min-mods-scsi.tar.bz2 -C /
		rm /min-mods-scsi.tar.bz2
		du -s /lib/modules
	EOT
fi

create_fs_image $mnt 4096 root-kombo.img

###############################################################################

echo -e "\n **** Create 'kombo-disk.img' ****\n"

dd if=/dev/zero of=$tmpdev bs=1k count=2880
mke2fs -m0 $tmpdev 2880 ; mount $tmpdev $mnt
cp -v root-kombo.img boot-disk/vmlinuz lilo-help.txt $mnt/
cp -v boot-disk/memtest86 $mnt/
cp -v boot-disk/boot-text.b $mnt/boot.b
tr '\n=\t-' '=\n\-\t' < lilo-conf-2.txt | \
sed 's,\\=-*,,' | tr '\n=\t-' '=\n\-\t' | grep -v '#' > $mnt/lilo.conf
sed -e "s,/mnt/,$mnt/,; s,/dev/floppy/0,$tmpdev,;" \
	< $mnt/lilo.conf > lilo.conf.tmp
boot-disk/lilo -C lilo.conf.tmp ; rm lilo.conf.tmp
umount $mnt ; dd if=$tmpdev of=kombo-disk.img bs=1k count=2880

###############################################################################

echo -e "\n **** Finish and Cleanup ****\n"

mkdir demo-setup ; mmv setup-\* demo-setup/\#1
tar cf demo-setup.tar demo-setup

mkdir -p $base/rock-$arch-$rockver/floppies/
mv System.map boot-disk/vmlinuz *.img boot-disk/memtest* demo-setup.tar \
	$base/rock-$arch-$rockver/floppies/
cp $base/arch-conf/$arch/kernel.conf $sd_srcdir/intel/README \
	mk-[br]ootdisk.sh $base/rock-$arch-$rockver/floppies/
chmod +x $base/rock-$arch-$rockver/floppies/mk-[br]ootdisk.sh
cd $base ; losetup -d $tmpdev ; rm -rf src/inst-disk
