#!/bin/sh

if [ $# != 3 ] ; then
	echo ""
	echo "Usage: $0 boot-image kernel-image floppy-dev"
	echo ""
	echo "E.g.: $0 boot-disk.img vmlinuz.my /dev/floppy/0"
	echo ""
	echo "This script is used to generate a boot floppy with an other"
	echo "kernel than the standard kernel."
	echo ""
	exit 1
fi

if [ ! -f "$1" ] ; then echo "No such file: $1"          ; exit 1 ; fi
if [ ! -f "$2" ] ; then echo "No such file: $2"          ; exit 1 ; fi
if [ ! -b "$3" ] ; then echo "No such block device: $3"  ; exit 1 ; fi

set -e

echo "Creating boot disk ($1 + $2) on device $3 ..."
mkdir -p /tmp/$$.mnt ; dd if="$1" of="$3"
mount "$3" /tmp/$$.mnt ; cp -v "$2" /tmp/$$.mnt/vmlinuz
sed -e "s,/mnt/,/tmp/$$.mnt/,; s,/dev/floppy/0,$3,;" \
	< /tmp/$$.mnt/lilo.conf > /tmp/$$.mnt/lilo.conf.tmp
/tmp/$$.mnt/lilo -C /tmp/$$.mnt/lilo.conf.tmp ; rm /tmp/$$.mnt/lilo.conf.tmp
umount /tmp/$$.mnt ; rmdir /tmp/$$.mnt
echo READY.
