#!/bin/sh

if [ $# != 4 ] ; then
	echo ""
	echo "Usage: $0 root-image setup-dir floppy-dev lo-dev"
	echo ""
	echo "E.g.: $0 root-disk.img setup.my/ /dev/floppy/0 /dev/loop/3"
	echo ""
	echo "This script is used to generate a root floppy with the data"
	echo "from the specified setup-dir on it."
	echo ""
	exit 1
fi

if [ ! -f "$1" ] ; then echo "No such file: $1"          ; exit 1 ; fi
if [ ! -d "$2" ] ; then echo "No such directory: $2"     ; exit 1 ; fi
if [ ! -b "$3" ] ; then echo "No such block device: $3"  ; exit 1 ; fi
if [ ! -b "$4" ] ; then echo "No such block device: $4"  ; exit 1 ; fi

set -e

echo "Creating root disk ($1 + $2) on device $3 using device $4 ..."
gunzip < "$1" > /tmp/$$.img ; losetup "$4" /tmp/$$.img
mkdir -p /tmp/$$.mnt        ; mount -t ext2 "$4" /tmp/$$.mnt

if [ -f "$2/copy2disk.sh" ]
then sh "$2/copy2disk.sh" "$2" /tmp/$$.mnt
else cp -a "$2" /tmp/$$.mnt/setup ; fi

umount /tmp/$$.mnt ; gzip -9 < "$4" > "$3" ; losetup -d "$4"
rm -rf /tmp/$$.mnt /tmp/$$.img  ;  echo READY.
