
xx() {
	if ! "$@" ; then
		while : ; do sleep 60 ; done
	fi
	return 0
}

instscr='pager 0\n'               # Disable pager (paranoia :-)
if [ $INSTALL_TYPE = full ] ; then
   instscr="$instscr"'sel\n'      # Select all packages
else
   instscr="$instscr"'sel mtr\n'  # Select some packages
   instscr="$instscr"'sel lsof\n'
   instscr="$instscr"'sel mtools\n'
   instscr="$instscr"'sel rsync\n'
   instscr="$instscr"'sel cdrecord\n'
   instscr="$instscr"'sel rfc\n'
   instscr="$instscr"'sel howtos\n'
   instscr="$instscr"'sel procinfo\n'
   instscr="$instscr"'sel isapnptools\n'
   instscr="$instscr"'sel pciutils\n'
   instscr="$instscr"'sel iproute2\n'
fi
instscr="$instscr"'inst\n''no'    # Install, no setup scripts

echo -e '\n ==> Creating partition table ...\n'
cat <<- EOT | xx sfdisk -f -uM /dev/discs/disc0/disc > /dev/null 2>&1
	,4	# Create Boot Partition     (4  MB)
	,96,S	# Create Swap Partition     (96 MB)
	,96	# Create Scratch Partition  (96 MB)
	,,,*	# Create Root Partition     (Rest)
EOT
xx fdisk -l /dev/discs/disc0/disc

echo -e '\n ==> Creating filesystem on the boot partition ...\n'
xx mke2fs -q /dev/discs/disc0/part1

echo -e '\n ==> Creating swap space on the swap partition ...\n'
xx mkswap /dev/discs/disc0/part2
xx swapon /dev/discs/disc0/part2

echo -e '\n ==> Creating filesystem on the scratch partition ...\n'
xx mke2fs -q /dev/discs/disc0/part3

echo -e '\n ==> Creating filesystem on the root partition ...\n'
xx mke2fs -q /dev/discs/disc0/part4

if [ "$INSTALL_SRC" = local ] ; then
	echo -e '\n ==> Mounting cdrom ...\n'
	xx mount -v -t iso9660 -o ro /dev/cdroms/cdrom0 /src
fi

echo -e '\n ==> Mounting target fs tree ...\n'
xx mount -v -t ext2 /dev/discs/disc0/part4 /trg ; mkdir /trg/boot
xx mount -v -t ext2 /dev/discs/disc0/part1 /trg/boot

echo -e '\n ==> Installing all base packages ...\n'
if [ "$INSTALL_SRC" = local ] ; then
	echo -e "$instscr" | xx Install
else
	echo -e "$instscr" | xx Net-Install "$INSTALL_SRC/rock-base-$ROCK_VER"
fi
