#
# The build script for ix86 PCs install disks
#

echo -e "\n **** Prepare creation of the root floppy ****\n"

mkdir -p src/inst-disk
cd src/inst-disk
cp $sd_srcdir/root-disk/* .

dd if=/dev/zero of=buffer bs=1k count=6144 ; tmpdev=x
for x in /dev/loop/* ; do
	if [ $tmpdev = x ] ; then
		echo "Trying to use loopback dev $x ..."
		if losetup $x buffer ; then tmpdev=$x ; fi
	fi
done
if [ $tmpdev = x ] ; then
	echo "No free loopback device found. Abort." ; exit 1
fi
echo "Using loop device $tmpdev."

echo 'Extracting install-disk fs.'
tar xIf $sd_instdir/install-disks.tar.bz2

echo 'Creating mount temporary point.'
mkdir disk.mnt ; mnt="`pwd`/disk.mnt"

echo -e "\n **** Create 'root-disk-big.img' ****\n"
dd if=/dev/zero of=$tmpdev bs=1k count=6144
mke2fs -m0 $tmpdev 6144 ; mount $tmpdev $mnt
cp -va install-disk/* $mnt/ ; umount $mnt
dd if=$tmpdev bs=1k count=6144 | gzip -9 > root-disk-big.img

echo -e "\n **** Create 'root-disk-small.img' ****\n"
rm -f install-disk/bin/{insmod,tune2fs,cfdisk,install_bin}
rm -f install-disk/lib/lib{ncurses,readline,tinfo}.so.*
rm -f install-disk/sbin/{confnet,Net-Install}
dd if=/dev/zero of=$tmpdev bs=1k count=4096
mke2fs -m0 $tmpdev 4096 ; mount $tmpdev $mnt
cp -va install-disk/* $mnt/ ; umount $mnt
dd if=$tmpdev bs=1k count=4096 | gzip -9 > root-disk-small.img

echo -e "\n **** Finish and Cleanup ****\n"
mkdir -p $base/rock-$arch-$rockver/floppies/
mv root-disk-*.img README mk-rootdisk.sh $base/rock-$arch-$rockver/floppies/
chmod +x $base/rock-$arch-$rockver/floppies/mk-rootdisk.sh
cd $base ; losetup -d $tmpdev ; rm -rf src/inst-disk
