#!/bin/sh -e

if [ -z "$1" -o ! -d "$1/etc" -o ! -d "$1/usr" ] ; then
	echo "Usage: $0 <root-dir>" ; exit 1
fi

SRCDIR=$PWD
cd "$1"

set -x

mkdir -p ram ram-tpl/misc
mv tmp ram-tpl/tmp ; ln -s ram/tmp tmp
mv var ram-tpl/var ; ln -s ram/var var
mv root ram-tpl/root ; ln -s ram/root root
mv home ram-tpl/home ; ln -s ram/home home
mv ram-tpl/var/adm etc/var-adm
ln -s ../../etc/var-adm ram-tpl/var/adm

touch ram-tpl/misc/mtab
ln -sf ../ram/misc/mtab etc/mtab

cat > etc/fstab << EOF
/dev/root       /                         auto            ro         0   0
none            /proc                     proc            defaults   0   0
none            /dev                      devfs           defaults   0   0
none            /dev/shm                  shm             defaults   0   0
none            /ram                      ramfs           defaults   0   0
EOF

cp etc/init.d/boot etc/init.d/boot.dist
patch --no-backup-if-mismatch etc/init.d/boot < "$SRCDIR"/boot.patch

cd ram ; ln -sf ../ram-tpl/* .
