echo "Cleaning up ..."
rm -rf src/ ; mkdir -p src/dist
cd src/dist

for x in 00-dirtree linux linux-src glibc binutils gcc bin86 bash sh-utils \
         fileutils findutils textutils diffutils patch make grep           \
         sed gzip tar gawk flex bzip2 bison joe vim bc mmv ncompress       \
         sysvinit shadow util-linux e2fsprogs net-tools dump portmap       \
         netkit-base netkit-ftp netkit-telnet sysfiles lilo portmap gpm    \
         ncurses wget cdrecord gettext libtool texinfo modutils termcap    \
         readline raidtools lvm install-disks ed nfs-utils m4 autoconf
do
    if [ -f $sd_pkgdir/$x.tar.bz2 ] ; then
	echo "Extracting $x.tar.bz2 ..."
	tar xIf $sd_pkgdir/$x.tar.bz2 --same-owner --same-permissions
    elif [ $x = lilo -o $x = bin86 -o $x = cdrecord -o \
           $x = raidtools -o $x = lvm ] ; then
	echo "Warning: Package '$x' not found."
    else
	echo "ERROR: Package '$x' not found."
	exit 1
    fi
done

echo "Removing documentation ..."
rm -rf usr/doc usr/man usr/info
rm -rf usr/share/doc usr/share/man usr/share/info

echo "Reducing kernel to headers and tarballs ..."
rm -rf usr/src/linux ; mkdir -p usr/src/linux
mv usr/src/linux-*/include usr/src/linux/include
rm -rf usr/src/linux-*

echo "Removing profiling libraries ..."
rm -rf usr/lib/*_p.a

echo "Removing package metadata ..."
rm -rf var/adm/cksums/* var/adm/md5sums/*
rm -rf var/adm/flists/* var/adm/logs

echo "Building subdistribution archive ..."
tar cIf $sd_instdir/rescue.tar.bz2 *
