#!/bin/sh

if [ $# -ne 3 ] ; then
	echo ""
	echo "  Usage: $0 Floppy-Dev Mtools-Drive Kernel-Image"
	echo ""
	echo "  Example: $0 /dev/floppy/0 a: bzImage"
	echo ""
	exit 1
fi

mformat $2 ; ./syslinux $1
mkdir /tmp/$$.mnt
mount -t msdos $1 /tmp/$$.mnt

cp $3 /tmp/$$.mnt/vmlinuz.bin
cp ./root-fs.img /tmp/$$.mnt/root-fs.bin
cp mod-base.mod /tmp/$$.mnt/base.mod

./rrl-tool lf2crlf > /tmp/$$.mnt/syslinux.cfg << "EOT"
DISPLAY showme.txt
LABEL Linux
  KERNEL vmlinuz.bin
  APPEND initrd=root-fs.bin root=/dev/ram devfs=nocompat
EOT

./rrl-tool lf2crlf > /tmp/$$.mnt/showme.txt << 'EOT'

 T H E   R O C K   R O U T E R   L I N U X                      #####
                                                               #######
                  #         http://www.rocklinux.org/          ##O#O##
 ######          ###                                           #VVVVV#
   ##             #                                          ##  VVV  ##
   ##         ###   ### ####   ###    ###  ##### ######     #          ##
   ##        #  ##   ###    ##  ##     ##    ###  ##       #            ##
   ##       #   ##   ##     ##  ##     ##      ###         #            ###
   ##          ###   ##     ##  ##     ##      ###        QQ#           ##Q
   ##       # ###    ##     ##  ##     ##     ## ##     QQQQQQ#        #QQQQQQ
   ##      ## ### #  ##     ##  ###   ###    ##   ##    QQQQQQQ#      #QQQQQQQ
 ############  ###  ####   ####   #### ### ##### ######   QQQQQ#######QQQQQ

EOT

touch /tmp/$$.mnt/config.txt

umount /tmp/$$.mnt
rmdir /tmp/$$.mnt
