# Build only for ix86
#
case "$arch_machine" in
	i?86) ;;
	*) echo "Only build ROCK Router Linux when" \
	        "making an Intel PC build." ; exit 0 ;;
esac

set -e

rm -rf $base/src/rock-router/
mkdir -p $base/src/rock-router/
cd $base/src/rock-router/

# Get a loopback dev
#
dd if=/dev/zero of=buffer bs=1k count=4096 ; tmpdev=x
for x in /dev/loop/* ; do
	if [ $tmpdev = x ] ; then
		echo "Trying to use loopback dev $x ..."
		if losetup $x buffer ; then tmpdev=$x ; fi
	fi
done
if [ $tmpdev = x ] ; then
	echo "No free loopback device found. Abort." ; exit 1
fi
echo "Using loop device $tmpdev."

# Create the rrl-tool bin
#
gcc -Wall -Werror $sd_srcdir/rrl-tool.c -o rrl-tool

# Create Modules
#
for module in mod-root mod-base ; do
	echo "Creating module $module ..."
	pwd_backup=`pwd` ; mkdir -p $module ; cd $module
	mkdir -p bin lib etc sbin dev mnt proc tmp config
	mkdir -p mod-init mod-list ; touch mod-list/$module
	{ . $sd_srcdir/$module.sh 2>&1 && touch ../$module.log ; } |
		while read x ; do echo "$x" | \
			tee -a ../$module.out | sed 's,^,>> ,' ; done
	if [ -f ../$module.log ] ; then mv ../$module.out ../$module.log
	else mv ../$module.out ../$module.err ; exit 1 ; fi
	cd $pwd_backup/$module ; ../rrl-tool c-archive `find * -type d -o \
		-type f -o -type l` | bzip2 > ../$module.mod
	cd $pwd_backup ; rm -rf $module
done

# Create root image
#
mkdir -p mnt ; dd if=/dev/zero of=$tmpdev bs=1k count=4096
mke2fs -q -m0 $tmpdev 4096 ; mount $tmpdev mnt ; cd mnt
bunzip2 < ../mod-root.mod | ../rrl-tool x-archive ; cd ..
umount mnt ; gzip -9 < $tmpdev > root-fs.img
rm -rf mnt mod-root.mod

# Create syslinux bin and MakeDisk.sh script
#
tar xIf $base/opt-archive/syslinux-1.48.tar.bz2
make -C syslinux-1.48 clean ; make -C syslinux-1.48 syslinux
mv syslinux-1.48/syslinux . ; rm -rf syslinux-1.48/
cp $sd_srcdir/MakeDisk.sh . ; chmod +x MakeDisk.sh

# Finish
#
losetup -d $tmpdev ; rm -f buffer
echo "Build rock-router.tar.bz2 ..." ; cd .. ; mkdir -p $sd_instdir
tar cIf $sd_instdir/rock-router.tar.bz2 rock-router/ ; rm -rf rock-router/
