#
# ROCK Router Linux Base Module
#

# Binaries
#
cd bin/
for x in insmod rmmod dump-config ip
do
	echo "Going to copy '$x' ..."
	line=`egrep -h " (bin|sbin|usr/bin|usr/sbin)/$x\$" $sd_infodir/flists/*`
	pnam=`echo $line | cut -f1 -d:`
	fnam=`echo $line | cut -f2 -d' '`
	if [ -z "$pnam" -o -z "$pnam" ] ; then
		echo "!!! Can't get prog '$x' !!!" ; exit 1
	fi
	tar xvIf $sd_pkgdir/$pnam.tar.bz2 $fnam
done
find */ ! -type d | xargs -i mv -v '{}' . ; rm -rf */
cd ..

# Init Scripts
#
cat > mod-init/100-base-modules.sh << 'EOT'
touch /config/modules.cfg
cp /config/modules.cfg /config/modules.dfl
sh -v /config/modules.cfg
EOT
#
cat > mod-init/300-base-ip.sh << 'EOT'
touch /config/ip.cfg
sh -v /config/ip.cfg
EOT
#
cat > mod-init/900-base-proc.sh << 'EOT'
touch /config/proc.cfg
dump-config proc /proc/sys > /config/proc.dfl
sh -v /config/proc.cfg
EOT

# Install Script
#
cat > mod-init/010-base-inst.sh << 'EOF'

echo >> sbin/save
cat >> sbin/save << 'EOT'
dump-config modules up /config/modules.dfl > /config/modules.cfg
cp /config/modules.cfg /config/modules.dfl
dump-config ip up > /config/ip.cfg
dump-config proc /proc/sys /config/proc.dfl > /config/proc.cfg
EOT

cat > sbin/insmod_wrapper << 'EOT'
#!/bin/sh
if insmod "$@" ; then
	exec >> /config/modules.dfl ; echo -n insmod $1 ; shift
	for x in "$@" ; do echo -n \ \'$x\' ; done ; echo
fi
EOT

chmod a=rx sbin/insmod_wrapper
echo 'alias insmod="insmod_wrapper"' >> etc/profile

EOF
