#
# ROCK Router Linux Root Module
#

# Basic libs and bins
#
cp ../rrl-tool bin/ ; cd bin
#
tar xIf $base/pkg-archive/busybox-0.46.tar.bz2 ; cd busybox-0.46
for x in $base/pkg-config/install-disks/busybox-*.patch ; do
[ "$x" = "$base/pkg-config/install-disks/busybox-config.patch" ] && continue
patch -Nfp0 < $x ; done ; patch -Nfp0 < $sd_srcdir/mod-root-busybox.patch
make ; make install PREFIX=../.. ; cd .. ; rm -rf busybox-0.46
#
for x in ksh bzip2 halt
do
	line=`egrep -h " (bin|sbin|usr/bin|usr/sbin)/$x\$" $sd_infodir/flists/*`
	pnam=`echo $line | cut -f1 -d:`
	fnam=`echo $line | cut -f2 -d' '`
	if [ -z "$pnam" -o -z "$pnam" ] ; then
		echo "!!! Can't get prog '$x' !!!" ; exit 1
	fi
	tar xvIf $sd_pkgdir/$pnam.tar.bz2 $fnam
done
find */ ! -type d | xargs -i mv -v '{}' . ; rm -rf */
mv -v ksh sh ; mv -v halt reboot
#
cd ..
egrep ' lib/(ld|libc)[\.-]' $sd_infodir/flists/glibc | \
	cut -f2 -d' ' | xargs tar xvIf $sd_pkgdir/glibc.tar.bz2
strip -v lib/* bin/*

# Simple Config files
#
cat > etc/fstab << 'EOT'
/dev/root       /       ext2   defaults
none            /proc   proc   noauto
none            /dev    devfs  noauto
EOT
#
echo -e 'ip 0 IP\nraw 255 RAW\nicmp 1 ICMP
tcp 6 TCP\nudp 17 UDP' > etc/protocols
#
echo 'root:x:0:0:root:/:' > etc/passwd
echo 'root:x:0:' > etc/group

# RRL Scripts
#
cat > sbin/init << 'EOT'
#!/bin/sh

cd / ; /bin/mount -t proc none /proc
ln -s ../proc/mounts /etc/mtab

. /etc/profile

mount -t msdos /dev/floppy/0 /mnt
rrl-tool imp-config /config < /mnt/config.txt
umount /mnt

load_module() {
	echo "Loading module $1 $2 $3 ..."
	cd / ; mount -t $2 $1 /mnt
	bzip2 -d < /mnt/$3 | rrl-tool x-archive
	umount /mnt
}

[ -f /config/INIT.cfg ] ||
	echo 'load_module /dev/floppy/0 msdos base.mod' > /config/INIT.cfg
. /config/INIT.cfg

for x in /mod-init/*.sh ; do
	if [ -f "$x" ] ; then
		echo "Running $x ..." ; sh $x
	fi
done

echo "READY. Enter console shell loop."

for x in /dev/vc/1 /dev/vc/2 /dev/vc/3 /dev/vc/4 ; do
	( while : ; do { echo ; /bin/sh -l ; } < $x > $x 2>&1 ; done ; ) &
done

while : ; do sleep 60 ; done
EOT

cat > sbin/save << 'EOT'
#!/bin/sh

if [ "$1" != "this_is_the_2nd_run" ] ; then
	$0 this_is_the_2nd_run
	mount -t msdos /dev/floppy/0 /mnt
	rrl-tool exp-config /config > /mnt/config.txt
	umount /mnt
	exit 0
fi

cd / ; echo 'Save Configuration ...'
EOT

cat > etc/profile << 'EOT'
export PATH=/bin:/sbin ; export TERM=linux ; set -o vi
export PS1="ROCK Router Linux [`tty | rrl-tool tr :/ /: | sed -e s/:dev:// | rrl-tool tr :/ /:`]> "
alias reboot="reboot -f" ; alias ping="ping -c 5"
EOT

chmod -R go=rX,u=rw .
chmod a+x lib/* bin/* sbin/*
