/*
 *  The ROCK Router Linux Tool
 *
 *  rrl-tool exp-config {config-dir} > {config-file}
 *  rrl-tool imp-config {config-dir} < {config-file}
 *
 *  rrl-tool c-archive {file-list} > {archive-file}
 *  rrl-tool x-archive < {archive-file}
 */

#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

/*
 *  Config Export and Import
 */

int exp_config_sel(const struct dirent * d) {
	return fnmatch("*.cfg",d->d_name,0) == 0;
}

int exp_config(int argc, char ** argv) {
	struct dirent **namelist;
	char fn[256];
	FILE *f; int n,ch;
	n = scandir(argv[2],&namelist,exp_config_sel,alphasort);
	if (n < 0) { perror("scandir"); return 1; }
	while(n--) {
		*(strstr(namelist[n]->d_name,".cfg"))=0;
		printf("=<[ %s ]>=\n",namelist[n]->d_name);
		sprintf(fn,"%s/%s.cfg",argv[2],namelist[n]->d_name);
		if ( (f=fopen(fn,"rt")) == NULL)
			{ perror("fopen"); return 1; }
		while ( (ch=getc(f)) != EOF) putchar(ch);
		fclose(f); putchar('\n');
	}
	return 0;
}

int imp_config(int argc, char ** argv) {
	char fn[256],buf[256],line[256];
	int nlc=0,c; FILE *f=NULL;
	line[255]=0;
	while ( fgets(line,255,stdin) != NULL) {
		if ( fnmatch("=<\\[ * \\]>=\n",line,0) == 0 ) {
			if (f != NULL) fclose(f);
			sscanf(line,"=<[ %s",buf);
			sprintf(fn,"%s/%s.cfg",argv[2],buf);
			if ( (f=fopen(fn,"wt")) == NULL)
				{ perror("fopen"); return 1; }
			nlc=0; continue;
		}
		if (f != NULL) {
			if (!strcmp(line,"\n")) { nlc++; continue; }
			for (c=0; c<nlc; c++) fputc('\n',f);
			fputs(line,f); nlc=0;
		}
	}
	if (f != NULL) fclose(f);
	return 1;
}


/*
 *  ROCK Router Linux Archives
 */

int c_archive(int argc, char ** argv) {
	struct stat st;
	int c,c2,bs,fd;
	char buf[512];
	
	for (c=2; c < argc; c++) {
		if ( lstat(argv[c],&st) != 0 )
			{ perror("stat"); return 1; }
		sprintf(buf,"%c %s %d %d %d %ld",
		        S_ISDIR(st.st_mode)?'d':(S_ISLNK(st.st_mode)?'l':'f'),
		        argv[c],st.st_mode,st.st_uid,st.st_gid,st.st_size);
		write(1,buf,strlen(buf)+1);
		if ( S_ISDIR(st.st_mode) ) continue;
		if ( S_ISLNK(st.st_mode) ) {
			bs=readlink(argv[c],buf,511);
			buf[bs]=0; write(1,buf,bs+1);
			continue;
		}
		if ( (fd=open(argv[c],O_RDONLY)) == -1 )
			{ perror("open"); return 1; }
		for (c2=0; c2 < st.st_size; c2+=bs) {
			bs=st.st_size-c2 > 512 ? 512 : st.st_size-c2;
			if ( (bs=read(fd,buf,bs)) <= 0 )
				{ perror("read"); return 1; }
			if ( write(1,buf,bs) != bs )
				{ perror("write"); return 1; }
		}
		close(fd);
	}
	return 0;
}

int x_archive(int argc, char ** argv) {
	struct stat st;
	char buf[512],fn[512],df;
	int c,c2,bs,fd;
	
	umask(0);
	while ( read(0,buf,1) == 1 ) {
		for (c=1; buf[c-1]; c++)
			if ( read(0,buf+c,1) != 1 )
				{ perror("read"); return 1; }
		if (sscanf(buf,"%c %s %d %d %d %ld",&df,fn,&st.st_mode,
		           &st.st_uid,&st.st_gid,&st.st_size) != 6)
			{ errno=EINVAL; perror("sscanf"); return 1; }
		if ( df == 'd' ) {
			mkdir(fn,st.st_mode);
			chown(fn,st.st_uid,st.st_gid);
			continue;
		}
		if ( df == 'l' ) {
			read(0,buf,1);
			for (c=1; buf[c-1]; c++)
				if ( read(0,buf+c,1) != 1 )
					{ perror("read"); return 1; }
			symlink(buf,fn);
			continue;
		}
		if ( (fd=creat(fn,st.st_mode)) == -1 )
			{ perror("creat"); return 1; }
		fchown(fd,st.st_uid,st.st_gid);
		for (c2=0; c2 < st.st_size; c2+=bs) {
			bs=st.st_size-c2 > 512 ? 512 : st.st_size-c2;
			if ( (bs=read(0,buf,bs)) <= 0 )
				{ perror("read"); return 1; }
			if ( write(fd,buf,bs) != bs )
				{ perror("write"); return 1; }
		}
		close(fd);
	}
	return 0;
}

/*
 *  Main
 */

int main(int argc, char ** argv) {
	/* Config file import/export */
	if (argc==3 && !strcmp(argv[1],"exp-config"))
		return exp_config(argc,argv);
	if (argc==3 && !strcmp(argv[1],"imp-config"))
		return imp_config(argc,argv);
	
	/* RRL Archives */
	if (argc>=3 && !strcmp(argv[1],"c-archive"))
		return c_archive(argc,argv);
	if (argc==2 && !strcmp(argv[1],"x-archive"))
		return x_archive(argc,argv);
	
	/* DOS<->UNIX Convertion */
	if (argc==2 && !strcmp(argv[1],"lf2crlf")) {
		char ch; while ( read(0,&ch,1) == 1 ) {
			if (ch != '\n') write(1,&ch,1);
			else write(1,"\r\n",2);
		} return 0;
	}
	if (argc==2 && !strcmp(argv[1],"crlf2lf")) {
		char ch; while ( read(0,&ch,1) == 1 ) {
			if (ch != '\r') write(1,&ch,1);
		} return 0;
	}
	
	/* replace characters */
	if (argc==4 && ! strcmp(argv[1],"tr")) {
		unsigned char tab[256];
		int c; unsigned char ch;
		for (c=0; c<256; c++) tab[c]=c;
		for (c=0; argv[2][c] && argv[3][c]; c++)
			tab[(unsigned char)argv[2][c]]=argv[3][c];
		while (read(0,&ch,1) == 1) write(1,tab+ch,1);
		return 0;
	}
	
	/* Usage msg */
	fprintf(stderr,"Usage: *RTFS*\n");
	return 1;
}
