#!/bin/sh

if [ $# -ne 8 ] ; then
	echo
	echo "Usage: ./MakeDisk.sh Root-Tar Kernel-Image Loop-Dev Floopy-Dev Mtools-Dev \\"
	echo "                     IP-Config Host-IP GPM-Paras"
	echo
	echo "Example: ./MakeDisk.sh root-fs.tar bzImage /dev/loop/4 /dev/floppy/0 a: \\"
	echo "                       'bootp' 192.168.11.5 '-tps2 -m/dev/misc/psaux'"
	echo
	echo "IP-Config is:   '<client-ip>::<gw-ip>:<netmask>::<device>:off'"
	echo "                or 'bootp' or 'rarp' or 'both'"
	echo
	exit 1
fi

dd if=/dev/zero of=/tmp/$$.img bs=1M count=4
losetup $3 /tmp/$$.img ; mke2fs -q -m0 $3
mkdir /tmp/$$.mnt ; mount $3 /tmp/$$.mnt

tar xf $1 -C /tmp/$$.mnt

cat > /tmp/$$.mnt/sbin/init << EOT
#!/bin/sh

cd / ; /bin/mount -t proc none /proc

export PATH="/bin:/usr/bin:/sbin:/usr/sbin"
export TERM="linux"

[ "$8" ] && gpm $8

run_telnet() {
	( while : ; do
		{ reset ; clear ; telnet $7 ; } \
			< /dev/vc/\$1 > /dev/vc/\$1 2>&1
	done ; ) &
}

for x in 1 2 3 4 5 6 ; do run_telnet \$x ; done

while : ; do sleep 60 ; done
EOT
chmod +x /tmp/$$.mnt/sbin/init

umount /tmp/$$.mnt ; losetup -d $3
mformat $5 ; ./syslinux $4
mount -t msdos $4 /tmp/$$.mnt

gzip -9 < /tmp/$$.img > /tmp/$$.mnt/root-fs.bin
cp $2 /tmp/$$.mnt/vmlinuz.bin

cat > /tmp/$$.mnt/syslinux.cfg << EOT
DISPLAY showme.txt
LABEL Linux
  KERNEL vmlinuz.bin
  APPEND initrd=root-fs.bin root=/dev/ram devfs=mount ip=$6
EOT

cat > /tmp/$$.mnt/showme.txt << "EOT"

 T H E   R O C K   T e l n e t   T e r m i n a l                #####
                                                               #######
                  #         http://www.rocklinux.org/          ##O#O##
 ######          ###                                           #VVVVV#
   ##             #                                          ##  VVV  ##
   ##         ###   ### ####   ###    ###  ##### ######     #          ##
   ##        #  ##   ###    ##  ##     ##    ###  ##       #            ##
   ##       #   ##   ##     ##  ##     ##      ###         #            ###
   ##          ###   ##     ##  ##     ##      ###        QQ#           ##Q
   ##       # ###    ##     ##  ##     ##     ## ##     QQQQQQ#        #QQQQQQ
   ##      ## ### #  ##     ##  ###   ###    ##   ##    QQQQQQQ#      #QQQQQQQ
 ############  ###  ####   ####   #### ### ##### ######   QQQQQ#######QQQQQ

EOT

umount /tmp/$$.mnt
rm -rf /tmp/$$.mnt /tmp/$$.img
