# Build only for ix86
#
case "$arch_machine" in
	i?86) ;;
	*) echo "Only build ROCK Telnet Linux when" \
	        "making an Intel PC build." ; exit 0 ;;
esac

set -e

rm -rf $base/src/rock-telnet/
mkdir -p $base/src/rock-telnet/
cd $base/src/rock-telnet/

mkdir disc ; cd disc
  echo "Creating dirs ..."
  mkdir -p bin sbin etc dev lib proc tmp var/run
  #
  echo "Extracting files ..."
  tar xIvf $sd_pkgdir/pdksh.tar.bz2 bin/sh_pdksh ; mv bin/sh_pdksh bin/sh
  tar xIvf $sd_pkgdir/glibc.tar.bz2 lib/ld-2.1.3.so lib/ld-linux.so.2 \
	lib/libc-2.1.3.so lib/libc.so.6 lib/libm-2.1.3.so lib/libm.so.6 \
	lib/libutil-2.1.3.so lib/libutil.so.1 lib/libnss_files-2.1.3.so \
	lib/libnss_files.so.2
  tar xIvf $sd_pkgdir/gcc.tar.bz2 usr/lib/libstdc++-libc6.1-2.so.3 \
	usr/lib/libstdc++-3-libc6.1-2-2.10.0.so
  tar xIvf $sd_pkgdir/ncurses.tar.bz2 usr/share/terminfo/l/linux \
	usr/lib/libncurses.so.5 usr/lib/libncurses.so.5.1 \
	usr/lib/libtinfo.so.5 usr/lib/libtinfo.so.5.1 \
	usr/bin/reset usr/bin/tset usr/bin/clear
  tar xIvf $sd_pkgdir/util-linux.tar.bz2 bin/mount
  tar xIvf $sd_pkgdir/gpm.tar.bz2 usr/sbin/gpm
  tar xIvf $sd_pkgdir/netkit-telnet.tar.bz2 usr/bin/telnet
  tar xIvf $sd_pkgdir/sh-utils.tar.bz2 bin/sleep
  #
  echo "Writing config files ..."
  echo 'root:x:0:0:root:/:' > etc/passwd
  echo 'root:x:0:' > etc/group
  echo 'telnet 23/tcp' > etc/services
  echo 'services: files' > etc/nsswitch.conf
  touch etc/fstab
  #
  echo "Stripping bins and libs ..."
  strip -v bin/* usr/bin/* usr/sbin/* lib/* usr/lib/*
  echo "Create root-fs.tar ..."
  tar cvf ../root-fs.tar *
cd .. ; rm -rf disc

tar xIf $base/opt-archive/syslinux-1.48.tar.bz2
make -C syslinux-1.48 clean ; make -C syslinux-1.48 syslinux
mv syslinux-1.48/syslinux . ; rm -rf syslinux-1.48/

echo "Extracting kernel sources ..."
tar xIf $sd_pkgdir/linux.tar.bz2 usr/src
cd usr/src/linux ; cp $sd_srcdir/kernel-cfg.txt .config
yes '' | make oldconfig ; make bzImage
cp arch/i386/boot/bzImage ../../..
cd ../../.. ; rm -rf usr

cp $sd_srcdir/MakeDisk.sh . ; chmod +x MakeDisk.sh

echo "Writing rock-telnet.tar.bz2 ..." ; cd ..
tar cIvf $sd_instdir/rock-telnet.tar.bz2 rock-telnet/
rm -rf rock-telnet/
