#!/bin/sh

lx_ver="2.4.0-test9"

if [ $# = 1 -a -d "$1" ] ; then
	dir_subd="$1/subdists/user-mode-linux" ; dir_base="$1"
else
	echo "Usage: <base-dir>" ; exit 1
fi

set -e

echo "Extracting unpatched kernel ..."
cd "$dir_base/src" ; rm -rf linux
tar xIf $dir_base/pkg-archive/linux-$lx_ver.tar.bz2 ; cd linux

echo "Patching the kernel ..."
echo "<$dir_base/opt-archive/uml-patch-$lx_ver.bz2>"
bunzip2 < $dir_base/opt-archive/uml-patch-$lx_ver.bz2 | patch -Nfp1
for x in $dir_subd/kernel/*.patch ; do
	echo "<$x>" ; patch -Nfp1 < $x
done

echo "Configuring the kernel ..."
yes '' | make oldconfig > config.out

echo "Building the kernel binary ..."
make linux UM_LIBS='-L/lib -L/usr/lib' > build.out 2>&1

echo "READY. Copy the binary ..."
cp linux ../um-linux.bin
