# --- ROCK-COPYRIGHT-NOTE-BEGIN ---
# 
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# Please add additional copyright information _after_ the line containing
# the ROCK-COPYRIGHT-NOTE-END tag. Otherwise it might get removed by
# the ./scripts/Create-CopyPatch script. Do not edit this copyright text!
# 
# ROCK Linux: rock-src/package/base/sysfiles/stone_gui_text.sh
# ROCK Linux is Copyright (C) 1998 - 2003 Clifford Wolf
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version. A copy of the GNU General Public
# License can be found at Documentation/COPYING.
# 
# Many people helped and are helping developing ROCK Linux. Please
# have a look at http://www.rocklinux.org/ and the Documentation/TEAM
# file for details.
# 
# --- ROCK-COPYRIGHT-NOTE-END ---

# Use: gui_menu "ID" "Title" "Text" "Action" [ "Text" "Action" [ .. ] ]
#
gui_menu() {
	echo ; echo "+---" ; echo "$2" | fold -s -70 | sed 's,^,|  ,'
	echo "+---" ; echo ; shift ; shift ; local nr=1 xnr=1 y

	while [ $# -ge 2 ] ; do
		y="${2#\*}"
		if [ -z "$y" ] ; then
			if [ -z "$1" ] ; then
				echo "       $1" ; shift ; shift
			else
				echo "    -  $1" ; shift ; shift
			fi
		else
			printf '%5d. %s\n' "$nr" "$1"
			eval "local action_$nr=\"\$y\""
			nr=$(( $nr + 1 )) ; shift ; shift
		fi
		xnr=$(( $xnr + 1 ))
		if [ $(( $xnr % 20 )) -eq 0 -a $# -gt 4 ] ; then
			echo
			read -p '== Press ENTER for next page =='
			echo
		fi
	done

	echo ; echo -n "> " ; read nr ; nr="action_$nr"
	[ -z "${!nr}" ] && return 1
	eval "${!nr}" ; return 0
}

# Use: gui_input "Text" "Default" "VarName"
#
gui_input() {
	echo ; echo "+---" ; echo "$1" | fold -s -66 | sed 's,^,|  ,'
	echo "+---" ; echo ; echo -n "[ $2 ] > " ; local tmp ; read tmp
	[ -z "$tmp" ] && tmp="$2" ; eval "$3=\"\$tmp\""
}

# Use: gui_yesno "Text"
#
# [returns 0 if yes, 1 if no]
gui_yesno() {
	local input y="[y]" n=" n "

	echo ; echo "+---"; echo "$1" | fold -s -66 | sed 's,^,|   ,'
	echo "+---" ; echo

	while :; do
		echo -en "\r? $y\t$n"
		read -sr -n 1 input

		if   [ "$input" = ""  ]; then break
		elif [ "$input" = "y" ]; then y="[y]"; n=" n "
		elif [ "$input" = "n" ]; then y=" y "; n="[n]"
		fi
	done

	[ "$input" = "[y]" ] && return 0
	return 1
}

# Use: gui_message "Text"
#
gui_message() {
	echo ; echo "+---" ; echo "$1" | fold -s -66 | sed 's,^,|  ,'
	echo "+---" ; echo ; echo "== Press ENTER to continue ==" ; read
}

# Use: gui_edit "Text" "File"
#
gui_edit() {
	eval "${EDITOR:-vi} $2"
}

# Use: gui_cmd "Title" "Command"
#
gui_cmd() {                       
        eval "$2"
	read -p "Press ENTER to continue."
}


