# --- ROCK-COPYRIGHT-NOTE-BEGIN ---
# 
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# Please add additional copyright information _after_ the line containing
# the ROCK-COPYRIGHT-NOTE-END tag. Otherwise it might get removed by
# the ./scripts/Create-CopyPatch script. Do not edit this copyright text!
# 
# ROCK Linux: rock-src/package/base/sysfiles/stone_mod_general.sh
# ROCK Linux is Copyright (C) 1998 - 2003 Clifford Wolf
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version. A copy of the GNU General Public
# License can be found at Documentation/COPYING.
# 
# Many people helped and are helping developing ROCK Linux. Please
# have a look at http://www.rocklinux.org/ and the Documentation/TEAM
# file for details.
# 
# --- ROCK-COPYRIGHT-NOTE-END ---
#
# [MAIN] 10 general,main Various general system configurations

set_keymap() {
	keymap=$(ls -l /etc/default.keymap 2> /dev/null | sed 's,.*/,,')
	[ -z "$keymap" ] && keymap="none" ; keymap="${keymap%.map.gz}"

	case "`uname -m`" in
	  i*86)
		mapdir="`echo /usr/share/kbd/keymaps/i386`"
		;;
	  ppc)
		mapdir="`echo /usr/share/kbd/keymaps/mac`" # ppc is a symlink
		;;
	  sparc*)
		mapdir="`echo /usr/share/kbd/keymaps/sun`"
		;;
	  *)
		gui_message "Can't auto-detect your architecture and so I can't find the right /usr/share/kbd/keymaps sub-directory for your system. Sorry."
		return
		;;
	esac

	cmd="gui_menu 'general_keymap' 'Select one of the"
	cmd="$cmd following keyboard mappings. (Current: $keymap)'"
	cmd="$cmd 'none (kernel defaults)' 'rm -f /etc/default.keymap ; loadkeys defkeymap'"

	cmd="$cmd $( find $mapdir -type f ! -path '*/include/*' -name '*.map.gz' -printf '%P\n' | sed 's,\(.*\)/\(.*\).map.gz$,"\2	(\1)" "ln -sf '$mapdir'/& /etc/default.keymap ; loadkeys \2",' | expand -30 | sort | tr '\n' ' ')"

	eval "$cmd"
}

store_kbd(){
	if [ -f /etc/conf/kbd ] ; then
		sed -e "s/kbd_rate=.*/kbd_rate=$kbd_rate/" \
		    -e "s/kbd_delay=.*/kbd_delay=$kbd_delay/" < /etc/conf/kbd \
		  > /etc/conf/kbd.tmp
		mv /etc/conf/kbd.tmp /etc/conf/kbd
	else
		echo -e "kbd_rate=$newkbd_rate\nkbd_delay=$newkbd_delay\n" \
		  > /etc/conf/kbd
	fi
	kbdrate -r $kbd_rate -d $kbd_delay
}

set_kbd_rate() {
	gui_input "Set new console keyboard auto-repeat rate" \
                  "$kbd_rate" "kbd_rate"
	store_kbd
}

set_kbd_delay() {
	gui_input "Set new console keyboard auto-repeat delay" \
                  "$kbd_delay" "kbd_delay"
	store_kbd
}

set_tmzone() {
	tz="$( ls -l /etc/localtime | cut -f7- -d/ )"
	cmd="gui_menu 'general_tmzone' 'Select one of the"
	cmd="$cmd following time zones. (Current: $tz)'"

	cmd="$cmd $( grep '^[^#]' /usr/share/zoneinfo/zone.tab | \
		cut -f3 | sort -u | tr '\n' ' ' | sed 's,[^ ]\+,& '`
		`'"ln -sf ../usr/share/zoneinfo/& /etc/localtime",g' )"

	eval "$cmd"
}

set_dtime() {
	dtime="`date '+%m-%d %H:%M %Y'`" ; newdtime="$dtime"
	gui_input "Set new date and time (MM-DD hh:mm YYYY, localtime)" \
	          "$dtime" "newdtime"
	if [ "$dtime" != "$newdtime" ] ; then
		echo "Setting new date and time ($newdtime) ..."
		date "$( echo $newdtime | sed 's,[^0-9],,g' )"
		hwclock --systohc --utc
	fi
}

set_locale_sub() {
	rm -f /etc/profile.d/locale
	[ "$1" != "none" ] && echo "export LANG='$1'" > /etc/profile.d/locale
}

set_locale() {
	unset LANG ; [ -f /etc/profile.d/locale ] && . /etc/profile.d/locale
	locale="${LANG:-none}" ; cmd="gui_menu 'general_locale' 'Select one of the following locales. (Current: $locale)' 'none' 'set_locale_sub none'"

	x="$( echo -e "POSIX\tC" | expand -52 )"
	cmd="$cmd '$x' 'set_locale_sub C' $(
		grep -H ^title /usr/share/i18n/locales/* 2> /dev/null | \
		awk -F '"' '{ sub(".*/", "", $1); sub("[\\.:].*", "", $1); '"
		printf \" '%-52s%s' 'set_locale_sub %s'\", \$2, \$1, \$1; }"
	)"

	eval "$cmd"
}

main() {
    while
	unset LANG ; [ -f /etc/profile.d/locale ] && . /etc/profile.d/locale
	locale="${LANG:-none}" ; tz="$( ls -l /etc/localtime | cut -f7- -d/ )"
	keymap=$(ls -l /etc/default.keymap 2> /dev/null | sed 's,.*/,,')
	[ "$keymap" ] || keymap="none" ; keymap="${keymap%.map.gz}"
	dtime="`date '+%m-%d %H:%M %Y'`"
	[ -f /etc/conf/kbd ] && . /etc/conf/kbd
	[ "$kbd_rate" ] || kbd_rate=30
	[ "$kbd_delay" ] || kbd_delay=250

	gui_menu general 'Various general system configurations' \
		"Set console keyboard mapping ....... $keymap" "set_keymap" \
		"Set system-wide time zone .......... $tz"     "set_tmzone" \
		"Set date and time (localtime) ...... $dtime"  "set_dtime"  \
		"Set system-wide locale (language) .. $locale" "set_locale" \
		"Set console keyboard repeat rate ... $kbd_rate" "set_kbd_rate" \
		"Set console keyboard repeat delay .. $kbd_delay" "set_kbd_delay" \
		"Run the (daily) 'cron.run' script now" "cron.run"
    do : ; done
}

