.\" Copyright (c) 2004 Dimitar Toshkov Zhekov
.TH BIZE 8 "15 Mar 2004"
.SH NAME
bize \- ROCK-Linux .tar.bz2 package manager
.SH SYNOPSIS
.BI "bize -i [-t] [-v] [-f] [-R " root "] " package1.tar.bz2
.BI ...
.LP
.BI "bize -r [-t] [-v] [-f] [-R " root "] " package1 " ..."
.SH DESCRIPTION
.B bize
is a shell script capable of installing, updating and removing
ROCK-Linux .tar.bz2 package files. It implements a subset of
.B mine
options.
.SS Requirements
.BR which " (or " type "), " sort ", " rm ", " rmdir ", "
.BR mkdir ", " tar " and " bzip2 ", and also " md5sum ", "
unless
.B "\-f"
is specified.
All these are standard programs present in any Linux system, but
.B bize
checks for them on startup anyway.
.PP
The operating system must be able to remove files being in use.
All Linux systems have this ability.
.SS Compatibility
The .tar.bz2 and .gem formats are not compatible. Packages
installed with
.B bize
can be removed with
.B mine
and vice-versa.
.B bize
has not been tested with ROCK-Linux 1.6 or earlier. Some of the
ROCK-Linux 1.7.0+ targets produce .tar.bz2 packages only.
.SS Effectiveness
.B bize
installs packages slightly faster than
.BR "mine "
and removes them about 25% faster (but see
.BR BUGS).
More time is usually required to remove a package than to install
it, so
.B bize
is, overall, about 15% faster than
.BR mine .
Needless to say, your mileage may vary.
.PP
The .tar.bz2 packages are a bit smaller than the .gem packages and
are created a bit faster.
.SH OPTIONS
.TP
.B "\-i"
Install or update packages.
.TP
.B "\-r"
Remove packages.
.TP
.B "\-t"
Test mode. Show what will happen without doing it.
.TP
.B "\-v"
Be verbose.
.TP
.B "\-f"
Force removal/replacement of the modified files.
.TP
.BI "\-r " root
Use
.I root
as root directory instead of
.BR / .
.TP
.B "\-\-"
Terminate the option list.
.SH BUGS
.B bize
will try to compute md5sum for any file with an md5sum entry,
even for devices and pipes. A normally built and installed ROCK-
Linux package includes md5sum entries for the regular files only.
.PP
.B bize
doesn't make backups, because I don't like them (of course, any
modified files are preserved unless
.B "\-f"
is specified).
.B mine
makes backups, so this is listed as a bug.
.SH SEE ALSO
GEM-MINE
