#!/bin/bash
#
# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: scripts/create-cache.sh
# Copyright (C) 2004 - 2005 The T2 SDE Project
# Copyright (C) 1998 - 2003 ROCK Linux Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---

if [ "$#" != 5 ] ; then
	echo "Usage: $0 <sdever> <buildtime> <stage> <pkg> <var-adm-dir>" >&2
	exit 1
fi

sdever=$1
buildtime=$2
stagelevel=$3
pkg=$4
varadm=$5

LC_ALL=C date '+%n[TIMESTAMP] %s %c'
echo -e "[ROCKVER] $sdever\n"

echo "[LOGS]" $( cd ${varadm}/logs ; ls ?-$pkg.* )
echo

if [ -f "${varadm}/logs/$stagelevel-$pkg.log" ]
then
	echo "[BUILDTIME] $buildtime ($stagelevel)"
	echo "[SIZE] `grep "^Package Size: " \
		${varadm}/packages/$pkg | cut -f3- -d' '`"
	echo

	cut -f2- -d' ' "${varadm}/dependencies/$pkg" |
	fmt -70 | sed 's,^,[DEP] ,'
	echo
fi

for stagelevel in 0 1 2 3 4 5 6 7 8 9 ; do
	if [ -f "${varadm}/logs/$stagelevel-$pkg.err" ] ; then
		tail -n 50 "${varadm}/logs/$stagelevel-$pkg.err" | \
			sed "s,^,[$stagelevel-ERROR] ,"
		echo
	fi
done
